package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ObjectKey,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectTorrentRequest(
    bucket: BucketName,
    key: ObjectKey,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest = {
    import GetObjectTorrentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest
      .wrap(buildAwsValue())
}
object GetObjectTorrentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest =
      io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest(
        bucketValue,
        keyValue,
        requestPayerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest
  ): io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest.ReadOnly =
    new Wrapper(impl)
}
