package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectTorrentResponse(
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse = {
    import GetObjectTorrentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse
      .wrap(buildAwsValue())
}
object GetObjectTorrentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse =
      io.github.vigoo.zioaws.s3.model
        .GetObjectTorrentResponse(requestChargedValue.map(value => value))
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly {
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse
  ): io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly =
    new Wrapper(impl)
}
