package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPublicAccessBlockResponse(
    publicAccessBlockConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse = {
    import GetPublicAccessBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
      .builder()
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse
      .wrap(buildAwsValue())
}
object GetPublicAccessBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse =
      io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse(
        publicAccessBlockConfigurationValue.map(value => value.editable)
      )
    def publicAccessBlockConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def publicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly {
    override def publicAccessBlockConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration.ReadOnly
    ] = scala
      .Option(impl.publicAccessBlockConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
  ): io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly =
    new Wrapper(impl)
}
