package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GlacierJobParameters(
    tier: io.github.vigoo.zioaws.s3.model.Tier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GlacierJobParameters = {
    import GlacierJobParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GlacierJobParameters
      .builder()
      .tier(tier.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GlacierJobParameters.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GlacierJobParameters.wrap(buildAwsValue())
}
object GlacierJobParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GlacierJobParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GlacierJobParameters =
      io.github.vigoo.zioaws.s3.model.GlacierJobParameters(tierValue)
    def tierValue: io.github.vigoo.zioaws.s3.model.Tier
    def tier: ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.Tier] =
      ZIO.succeed(tierValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GlacierJobParameters
  ) extends io.github.vigoo.zioaws.s3.model.GlacierJobParameters.ReadOnly {
    override def tierValue: io.github.vigoo.zioaws.s3.model.Tier =
      io.github.vigoo.zioaws.s3.model.Tier.wrap(impl.tier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GlacierJobParameters
  ): io.github.vigoo.zioaws.s3.model.GlacierJobParameters.ReadOnly =
    new Wrapper(impl)
}
