package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Grant(
    grantee: Option[io.github.vigoo.zioaws.s3.model.Grantee] = None,
    permission: Option[io.github.vigoo.zioaws.s3.model.Permission] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Grant = {
    import Grant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Grant
      .builder()
      .optionallyWith(grantee.map(value => value.buildAwsValue()))(_.grantee)
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Grant.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Grant.wrap(buildAwsValue())
}
object Grant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Grant] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Grant =
      io.github.vigoo.zioaws.s3.model.Grant(
        granteeValue.map(value => value.editable),
        permissionValue.map(value => value)
      )
    def granteeValue: Option[io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly]
    def permissionValue: Option[io.github.vigoo.zioaws.s3.model.Permission]
    def grantee
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly] =
      AwsError.unwrapOptionField("grantee", granteeValue)
    def permission
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Permission] =
      AwsError.unwrapOptionField("permission", permissionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Grant)
      extends io.github.vigoo.zioaws.s3.model.Grant.ReadOnly {
    override def granteeValue
        : Option[io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly] = scala
      .Option(impl.grantee())
      .map(value => io.github.vigoo.zioaws.s3.model.Grantee.wrap(value))
    override def permissionValue
        : Option[io.github.vigoo.zioaws.s3.model.Permission] = scala
      .Option(impl.permission())
      .map(value => io.github.vigoo.zioaws.s3.model.Permission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Grant
  ): io.github.vigoo.zioaws.s3.model.Grant.ReadOnly = new Wrapper(impl)
}
