package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  URI,
  ID,
  EmailAddress,
  DisplayName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Grantee(
    displayName: Option[DisplayName] = None,
    emailAddress: Option[EmailAddress] = None,
    id: Option[ID] = None,
    `type`: io.github.vigoo.zioaws.s3.model.Type,
    uri: Option[URI] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Grantee = {
    import Grantee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Grantee
      .builder()
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(emailAddress.map(value => value: java.lang.String))(
        _.emailAddress
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .`type`(`type`.unwrap)
      .optionallyWith(uri.map(value => value: java.lang.String))(_.uri)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Grantee.wrap(buildAwsValue())
}
object Grantee {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Grantee] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Grantee =
      io.github.vigoo.zioaws.s3.model.Grantee(
        displayNameValue.map(value => value),
        emailAddressValue.map(value => value),
        idValue.map(value => value),
        typeValue,
        uriValue.map(value => value)
      )
    def displayNameValue: Option[DisplayName]
    def emailAddressValue: Option[EmailAddress]
    def idValue: Option[ID]
    def typeValue: io.github.vigoo.zioaws.s3.model.Type
    def uriValue: Option[URI]
    def displayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayNameValue)
    def emailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddressValue)
    def id: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", idValue)
    def `type`: ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.Type] =
      ZIO.succeed(typeValue)
    def uri: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("uri", uriValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Grantee)
      extends io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly {
    override def displayNameValue: Option[DisplayName] =
      scala.Option(impl.displayName()).map(value => value: DisplayName)
    override def emailAddressValue: Option[EmailAddress] =
      scala.Option(impl.emailAddress()).map(value => value: EmailAddress)
    override def idValue: Option[ID] =
      scala.Option(impl.id()).map(value => value: ID)
    override def typeValue: io.github.vigoo.zioaws.s3.model.Type =
      io.github.vigoo.zioaws.s3.model.Type.wrap(impl.`type`())
    override def uriValue: Option[URI] =
      scala.Option(impl.uri()).map(value => value: URI)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Grantee
  ): io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly = new Wrapper(impl)
}
