package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  AccountId,
  SSECustomerAlgorithm,
  IfModifiedSince,
  IfNoneMatch,
  IfMatch,
  SSECustomerKeyMD5,
  ObjectKey,
  BucketName,
  IfUnmodifiedSince,
  ObjectVersionId,
  PartNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class HeadObjectRequest(
    bucket: BucketName,
    ifMatch: Option[IfMatch] = None,
    ifModifiedSince: Option[IfModifiedSince] = None,
    ifNoneMatch: Option[IfNoneMatch] = None,
    ifUnmodifiedSince: Option[IfUnmodifiedSince] = None,
    key: ObjectKey,
    range: Option[io.github.vigoo.zioaws.s3.model.primitives.Range] = None,
    versionId: Option[ObjectVersionId] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    partNumber: Option[PartNumber] = None,
    expectedBucketOwner: Option[AccountId] = None,
    checksumMode: Option[io.github.vigoo.zioaws.s3.model.ChecksumMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.HeadObjectRequest = {
    import HeadObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.HeadObjectRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .optionallyWith(ifModifiedSince.map(value => value: Instant))(
        _.ifModifiedSince
      )
      .optionallyWith(ifNoneMatch.map(value => value: java.lang.String))(
        _.ifNoneMatch
      )
      .optionallyWith(ifUnmodifiedSince.map(value => value: Instant))(
        _.ifUnmodifiedSince
      )
      .key(key: java.lang.String)
      .optionallyWith(range.map(value => value: java.lang.String))(_.range)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(partNumber.map(value => value: Integer))(_.partNumber)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(checksumMode.map(value => value.unwrap))(_.checksumMode)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.HeadObjectRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.HeadObjectRequest.wrap(buildAwsValue())
}
object HeadObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.HeadObjectRequest =
      io.github.vigoo.zioaws.s3.model.HeadObjectRequest(
        bucketValue,
        ifMatchValue.map(value => value),
        ifModifiedSinceValue.map(value => value),
        ifNoneMatchValue.map(value => value),
        ifUnmodifiedSinceValue.map(value => value),
        keyValue,
        rangeValue.map(value => value),
        versionIdValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        requestPayerValue.map(value => value),
        partNumberValue.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        checksumModeValue.map(value => value)
      )
    def bucketValue: BucketName
    def ifMatchValue: Option[IfMatch]
    def ifModifiedSinceValue: Option[IfModifiedSince]
    def ifNoneMatchValue: Option[IfNoneMatch]
    def ifUnmodifiedSinceValue: Option[IfUnmodifiedSince]
    def keyValue: ObjectKey
    def rangeValue: Option[io.github.vigoo.zioaws.s3.model.primitives.Range]
    def versionIdValue: Option[ObjectVersionId]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def partNumberValue: Option[PartNumber]
    def expectedBucketOwnerValue: Option[AccountId]
    def checksumModeValue: Option[io.github.vigoo.zioaws.s3.model.ChecksumMode]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def ifMatch: ZIO[Any, AwsError, IfMatch] =
      AwsError.unwrapOptionField("ifMatch", ifMatchValue)
    def ifModifiedSince: ZIO[Any, AwsError, IfModifiedSince] =
      AwsError.unwrapOptionField("ifModifiedSince", ifModifiedSinceValue)
    def ifNoneMatch: ZIO[Any, AwsError, IfNoneMatch] =
      AwsError.unwrapOptionField("ifNoneMatch", ifNoneMatchValue)
    def ifUnmodifiedSince: ZIO[Any, AwsError, IfUnmodifiedSince] =
      AwsError.unwrapOptionField("ifUnmodifiedSince", ifUnmodifiedSinceValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def range
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.primitives.Range] =
      AwsError.unwrapOptionField("range", rangeValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def partNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumberValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def checksumMode
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ChecksumMode] =
      AwsError.unwrapOptionField("checksumMode", checksumModeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ) extends io.github.vigoo.zioaws.s3.model.HeadObjectRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def ifMatchValue: Option[IfMatch] =
      scala.Option(impl.ifMatch()).map(value => value: IfMatch)
    override def ifModifiedSinceValue: Option[IfModifiedSince] =
      scala.Option(impl.ifModifiedSince()).map(value => value: IfModifiedSince)
    override def ifNoneMatchValue: Option[IfNoneMatch] =
      scala.Option(impl.ifNoneMatch()).map(value => value: IfNoneMatch)
    override def ifUnmodifiedSinceValue: Option[IfUnmodifiedSince] = scala
      .Option(impl.ifUnmodifiedSince())
      .map(value => value: IfUnmodifiedSince)
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def rangeValue
        : Option[io.github.vigoo.zioaws.s3.model.primitives.Range] = scala
      .Option(impl.range())
      .map(value => value: io.github.vigoo.zioaws.s3.model.primitives.Range)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def partNumberValue: Option[PartNumber] =
      scala.Option(impl.partNumber()).map(value => value: PartNumber)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def checksumModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumMode] = scala
      .Option(impl.checksumMode())
      .map(value => io.github.vigoo.zioaws.s3.model.ChecksumMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ): io.github.vigoo.zioaws.s3.model.HeadObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
