package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{
  ContentType,
  ETag,
  CacheControl,
  WebsiteRedirectLocation,
  AcceptRanges,
  ContentDisposition,
  ContentLanguage,
  Expiration,
  ContentLength,
  PartsCount,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  DeleteMarker,
  ChecksumSHA256,
  LastModified,
  Expires,
  ContentEncoding,
  ChecksumCRC32C,
  ChecksumCRC32,
  MissingMeta,
  ChecksumSHA1,
  SSEKMSKeyId,
  MetadataValue,
  ObjectLockRetainUntilDate,
  Restore,
  ObjectVersionId,
  MetadataKey,
  BucketKeyEnabled
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class HeadObjectResponse(
    deleteMarker: Option[DeleteMarker] = None,
    acceptRanges: Option[AcceptRanges] = None,
    expiration: Option[Expiration] = None,
    restore: Option[Restore] = None,
    archiveStatus: Option[io.github.vigoo.zioaws.s3.model.ArchiveStatus] = None,
    lastModified: Option[LastModified] = None,
    contentLength: Option[ContentLength] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None,
    eTag: Option[ETag] = None,
    missingMeta: Option[MissingMeta] = None,
    versionId: Option[ObjectVersionId] = None,
    cacheControl: Option[CacheControl] = None,
    contentDisposition: Option[ContentDisposition] = None,
    contentEncoding: Option[ContentEncoding] = None,
    contentLanguage: Option[ContentLanguage] = None,
    contentType: Option[ContentType] = None,
    expires: Option[Expires] = None,
    websiteRedirectLocation: Option[WebsiteRedirectLocation] = None,
    serverSideEncryption: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = None,
    metadata: Option[Map[MetadataKey, MetadataValue]] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None,
    replicationStatus: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationStatus
    ] = None,
    partsCount: Option[PartsCount] = None,
    objectLockMode: Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode] =
      None,
    objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] = None,
    objectLockLegalHoldStatus: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.HeadObjectResponse = {
    import HeadObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.HeadObjectResponse
      .builder()
      .optionallyWith(deleteMarker.map(value => value: java.lang.Boolean))(
        _.deleteMarker
      )
      .optionallyWith(acceptRanges.map(value => value: java.lang.String))(
        _.acceptRanges
      )
      .optionallyWith(expiration.map(value => value: java.lang.String))(
        _.expiration
      )
      .optionallyWith(restore.map(value => value: java.lang.String))(_.restore)
      .optionallyWith(archiveStatus.map(value => value.unwrap))(_.archiveStatus)
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(contentLength.map(value => value: java.lang.Long))(
        _.contentLength
      )
      .optionallyWith(checksumCRC32.map(value => value: java.lang.String))(
        _.checksumCRC32
      )
      .optionallyWith(checksumCRC32C.map(value => value: java.lang.String))(
        _.checksumCRC32C
      )
      .optionallyWith(checksumSHA1.map(value => value: java.lang.String))(
        _.checksumSHA1
      )
      .optionallyWith(checksumSHA256.map(value => value: java.lang.String))(
        _.checksumSHA256
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(missingMeta.map(value => value: Integer))(_.missingMeta)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(cacheControl.map(value => value: java.lang.String))(
        _.cacheControl
      )
      .optionallyWith(contentDisposition.map(value => value: java.lang.String))(
        _.contentDisposition
      )
      .optionallyWith(contentEncoding.map(value => value: java.lang.String))(
        _.contentEncoding
      )
      .optionallyWith(contentLanguage.map(value => value: java.lang.String))(
        _.contentLanguage
      )
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(expires.map(value => value: Instant))(_.expires)
      .optionallyWith(
        websiteRedirectLocation.map(value => value: java.lang.String)
      )(_.websiteRedirectLocation)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(ssekmsKeyId.map(value => value: java.lang.String))(
        _.ssekmsKeyId
      )
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(replicationStatus.map(value => value.unwrap))(
        _.replicationStatus
      )
      .optionallyWith(partsCount.map(value => value: Integer))(_.partsCount)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(objectLockRetainUntilDate.map(value => value: Instant))(
        _.objectLockRetainUntilDate
      )
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.HeadObjectResponse.wrap(buildAwsValue())
}
object HeadObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.HeadObjectResponse =
      io.github.vigoo.zioaws.s3.model.HeadObjectResponse(
        deleteMarkerValue.map(value => value),
        acceptRangesValue.map(value => value),
        expirationValue.map(value => value),
        restoreValue.map(value => value),
        archiveStatusValue.map(value => value),
        lastModifiedValue.map(value => value),
        contentLengthValue.map(value => value),
        checksumCRC32Value.map(value => value),
        checksumCRC32CValue.map(value => value),
        checksumSHA1Value.map(value => value),
        checksumSHA256Value.map(value => value),
        eTagValue.map(value => value),
        missingMetaValue.map(value => value),
        versionIdValue.map(value => value),
        cacheControlValue.map(value => value),
        contentDispositionValue.map(value => value),
        contentEncodingValue.map(value => value),
        contentLanguageValue.map(value => value),
        contentTypeValue.map(value => value),
        expiresValue.map(value => value),
        websiteRedirectLocationValue.map(value => value),
        serverSideEncryptionValue.map(value => value),
        metadataValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        ssekmsKeyIdValue.map(value => value),
        bucketKeyEnabledValue.map(value => value),
        storageClassValue.map(value => value),
        requestChargedValue.map(value => value),
        replicationStatusValue.map(value => value),
        partsCountValue.map(value => value),
        objectLockModeValue.map(value => value),
        objectLockRetainUntilDateValue.map(value => value),
        objectLockLegalHoldStatusValue.map(value => value)
      )
    def deleteMarkerValue: Option[DeleteMarker]
    def acceptRangesValue: Option[AcceptRanges]
    def expirationValue: Option[Expiration]
    def restoreValue: Option[Restore]
    def archiveStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ArchiveStatus]
    def lastModifiedValue: Option[LastModified]
    def contentLengthValue: Option[ContentLength]
    def checksumCRC32Value: Option[ChecksumCRC32]
    def checksumCRC32CValue: Option[ChecksumCRC32C]
    def checksumSHA1Value: Option[ChecksumSHA1]
    def checksumSHA256Value: Option[ChecksumSHA256]
    def eTagValue: Option[ETag]
    def missingMetaValue: Option[MissingMeta]
    def versionIdValue: Option[ObjectVersionId]
    def cacheControlValue: Option[CacheControl]
    def contentDispositionValue: Option[ContentDisposition]
    def contentEncodingValue: Option[ContentEncoding]
    def contentLanguageValue: Option[ContentLanguage]
    def contentTypeValue: Option[ContentType]
    def expiresValue: Option[Expires]
    def websiteRedirectLocationValue: Option[WebsiteRedirectLocation]
    def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption]
    def metadataValue: Option[Map[MetadataKey, MetadataValue]]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def ssekmsKeyIdValue: Option[SSEKMSKeyId]
    def bucketKeyEnabledValue: Option[BucketKeyEnabled]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def replicationStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationStatus]
    def partsCountValue: Option[PartsCount]
    def objectLockModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDateValue: Option[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus]
    def deleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarkerValue)
    def acceptRanges: ZIO[Any, AwsError, AcceptRanges] =
      AwsError.unwrapOptionField("acceptRanges", acceptRangesValue)
    def expiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expirationValue)
    def restore: ZIO[Any, AwsError, Restore] =
      AwsError.unwrapOptionField("restore", restoreValue)
    def archiveStatus
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ArchiveStatus] =
      AwsError.unwrapOptionField("archiveStatus", archiveStatusValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
    def contentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLengthValue)
    def checksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32Value)
    def checksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32CValue)
    def checksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1Value)
    def checksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256Value)
    def eTag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTagValue)
    def missingMeta: ZIO[Any, AwsError, MissingMeta] =
      AwsError.unwrapOptionField("missingMeta", missingMetaValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def cacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControlValue)
    def contentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDispositionValue)
    def contentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncodingValue)
    def contentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguageValue)
    def contentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentTypeValue)
    def expires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expiresValue)
    def websiteRedirectLocation: ZIO[Any, AwsError, WebsiteRedirectLocation] =
      AwsError.unwrapOptionField(
        "websiteRedirectLocation",
        websiteRedirectLocationValue
      )
    def serverSideEncryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = AwsError.unwrapOptionField(
      "serverSideEncryption",
      serverSideEncryptionValue
    )
    def metadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadataValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def ssekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyIdValue)
    def bucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabledValue)
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
    def replicationStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ReplicationStatus
    ] = AwsError.unwrapOptionField("replicationStatus", replicationStatusValue)
    def partsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("partsCount", partsCountValue)
    def objectLockMode
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockModeValue)
    def objectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] =
      AwsError.unwrapOptionField(
        "objectLockRetainUntilDate",
        objectLockRetainUntilDateValue
      )
    def objectLockLegalHoldStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus
    ] = AwsError.unwrapOptionField(
      "objectLockLegalHoldStatus",
      objectLockLegalHoldStatusValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ) extends io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly {
    override def deleteMarkerValue: Option[DeleteMarker] =
      scala.Option(impl.deleteMarker()).map(value => value: DeleteMarker)
    override def acceptRangesValue: Option[AcceptRanges] =
      scala.Option(impl.acceptRanges()).map(value => value: AcceptRanges)
    override def expirationValue: Option[Expiration] =
      scala.Option(impl.expiration()).map(value => value: Expiration)
    override def restoreValue: Option[Restore] =
      scala.Option(impl.restore()).map(value => value: Restore)
    override def archiveStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ArchiveStatus] = scala
      .Option(impl.archiveStatus())
      .map(value => io.github.vigoo.zioaws.s3.model.ArchiveStatus.wrap(value))
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
    override def contentLengthValue: Option[ContentLength] =
      scala.Option(impl.contentLength()).map(value => value: ContentLength)
    override def checksumCRC32Value: Option[ChecksumCRC32] =
      scala.Option(impl.checksumCRC32()).map(value => value: ChecksumCRC32)
    override def checksumCRC32CValue: Option[ChecksumCRC32C] =
      scala.Option(impl.checksumCRC32C()).map(value => value: ChecksumCRC32C)
    override def checksumSHA1Value: Option[ChecksumSHA1] =
      scala.Option(impl.checksumSHA1()).map(value => value: ChecksumSHA1)
    override def checksumSHA256Value: Option[ChecksumSHA256] =
      scala.Option(impl.checksumSHA256()).map(value => value: ChecksumSHA256)
    override def eTagValue: Option[ETag] =
      scala.Option(impl.eTag()).map(value => value: ETag)
    override def missingMetaValue: Option[MissingMeta] =
      scala.Option(impl.missingMeta()).map(value => value: MissingMeta)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def cacheControlValue: Option[CacheControl] =
      scala.Option(impl.cacheControl()).map(value => value: CacheControl)
    override def contentDispositionValue: Option[ContentDisposition] = scala
      .Option(impl.contentDisposition())
      .map(value => value: ContentDisposition)
    override def contentEncodingValue: Option[ContentEncoding] =
      scala.Option(impl.contentEncoding()).map(value => value: ContentEncoding)
    override def contentLanguageValue: Option[ContentLanguage] =
      scala.Option(impl.contentLanguage()).map(value => value: ContentLanguage)
    override def contentTypeValue: Option[ContentType] =
      scala.Option(impl.contentType()).map(value => value: ContentType)
    override def expiresValue: Option[Expires] =
      scala.Option(impl.expires()).map(value => value: Expires)
    override def websiteRedirectLocationValue: Option[WebsiteRedirectLocation] =
      scala
        .Option(impl.websiteRedirectLocation())
        .map(value => value: WebsiteRedirectLocation)
    override def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryption.wrap(value)
      )
    override def metadataValue: Option[Map[MetadataKey, MetadataValue]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: MetadataKey) -> (value: MetadataValue)
          })
          .toMap
      )
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def ssekmsKeyIdValue: Option[SSEKMSKeyId] =
      scala.Option(impl.ssekmsKeyId()).map(value => value: SSEKMSKeyId)
    override def bucketKeyEnabledValue: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => value: BucketKeyEnabled)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
    override def replicationStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationStatus] = scala
      .Option(impl.replicationStatus())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ReplicationStatus.wrap(value)
      )
    override def partsCountValue: Option[PartsCount] =
      scala.Option(impl.partsCount()).map(value => value: PartsCount)
    override def objectLockModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => io.github.vigoo.zioaws.s3.model.ObjectLockMode.wrap(value))
    override def objectLockRetainUntilDateValue
        : Option[ObjectLockRetainUntilDate] = scala
      .Option(impl.objectLockRetainUntilDate())
      .map(value => value: ObjectLockRetainUntilDate)
    override def objectLockLegalHoldStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus] =
      scala
        .Option(impl.objectLockLegalHoldStatus())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ): io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
