package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Suffix
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IndexDocument(suffix: Suffix) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IndexDocument = {
    import IndexDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IndexDocument
      .builder()
      .suffix(suffix: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly =
    io.github.vigoo.zioaws.s3.model.IndexDocument.wrap(buildAwsValue())
}
object IndexDocument {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.IndexDocument] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.IndexDocument =
      io.github.vigoo.zioaws.s3.model.IndexDocument(suffixValue)
    def suffixValue: Suffix
    def suffix: ZIO[Any, Nothing, Suffix] = ZIO.succeed(suffixValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IndexDocument
  ) extends io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly {
    override def suffixValue: Suffix = impl.suffix(): Suffix
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IndexDocument
  ): io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly = new Wrapper(impl)
}
