package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{DisplayName, ID}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Initiator(
    id: Option[ID] = None,
    displayName: Option[DisplayName] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Initiator = {
    import Initiator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Initiator
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Initiator.wrap(buildAwsValue())
}
object Initiator {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Initiator] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Initiator =
      io.github.vigoo.zioaws.s3.model.Initiator(
        idValue.map(value => value),
        displayNameValue.map(value => value)
      )
    def idValue: Option[ID]
    def displayNameValue: Option[DisplayName]
    def id: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", idValue)
    def displayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Initiator
  ) extends io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly {
    override def idValue: Option[ID] =
      scala.Option(impl.id()).map(value => value: ID)
    override def displayNameValue: Option[DisplayName] =
      scala.Option(impl.displayName()).map(value => value: DisplayName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Initiator
  ): io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly = new Wrapper(impl)
}
