package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputSerialization(
    csv: Option[io.github.vigoo.zioaws.s3.model.CSVInput] = None,
    compressionType: Option[io.github.vigoo.zioaws.s3.model.CompressionType] =
      None,
    json: Option[io.github.vigoo.zioaws.s3.model.JSONInput] = None,
    parquet: Option[io.github.vigoo.zioaws.s3.model.ParquetInput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InputSerialization = {
    import InputSerialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InputSerialization
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .optionallyWith(parquet.map(value => value.buildAwsValue()))(_.parquet)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly =
    io.github.vigoo.zioaws.s3.model.InputSerialization.wrap(buildAwsValue())
}
object InputSerialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InputSerialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.InputSerialization =
      io.github.vigoo.zioaws.s3.model.InputSerialization(
        csvValue.map(value => value.editable),
        compressionTypeValue.map(value => value),
        jsonValue.map(value => value.editable),
        parquetValue.map(value => value.editable)
      )
    def csvValue: Option[io.github.vigoo.zioaws.s3.model.CSVInput.ReadOnly]
    def compressionTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.CompressionType]
    def jsonValue: Option[io.github.vigoo.zioaws.s3.model.JSONInput.ReadOnly]
    def parquetValue
        : Option[io.github.vigoo.zioaws.s3.model.ParquetInput.ReadOnly]
    def csv: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.CSVInput.ReadOnly
    ] = AwsError.unwrapOptionField("csv", csvValue)
    def compressionType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionTypeValue)
    def json: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.JSONInput.ReadOnly
    ] = AwsError.unwrapOptionField("json", jsonValue)
    def parquet: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ParquetInput.ReadOnly
    ] = AwsError.unwrapOptionField("parquet", parquetValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InputSerialization
  ) extends io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly {
    override def csvValue
        : Option[io.github.vigoo.zioaws.s3.model.CSVInput.ReadOnly] = scala
      .Option(impl.csv())
      .map(value => io.github.vigoo.zioaws.s3.model.CSVInput.wrap(value))
    override def compressionTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.CompressionType] = scala
      .Option(impl.compressionType())
      .map(value => io.github.vigoo.zioaws.s3.model.CompressionType.wrap(value))
    override def jsonValue
        : Option[io.github.vigoo.zioaws.s3.model.JSONInput.ReadOnly] = scala
      .Option(impl.json())
      .map(value => io.github.vigoo.zioaws.s3.model.JSONInput.wrap(value))
    override def parquetValue
        : Option[io.github.vigoo.zioaws.s3.model.ParquetInput.ReadOnly] = scala
      .Option(impl.parquet())
      .map(value => io.github.vigoo.zioaws.s3.model.ParquetInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InputSerialization
  ): io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly = new Wrapper(
    impl
  )
}
