package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Prefix
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IntelligentTieringAndOperator(
    prefix: Option[Prefix] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.s3.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator = {
    import IntelligentTieringAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator.ReadOnly =
    io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator
      .wrap(buildAwsValue())
}
object IntelligentTieringAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator =
      io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator(
        prefixValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def prefixValue: Option[Prefix]
    def tagsValue: Option[List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
  ) extends io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringAndOperator
  ): io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator.ReadOnly =
    new Wrapper(impl)
}
