package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.IntelligentTieringId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IntelligentTieringConfiguration(
    id: IntelligentTieringId,
    filter: Option[io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter] =
      None,
    status: io.github.vigoo.zioaws.s3.model.IntelligentTieringStatus,
    tierings: Iterable[io.github.vigoo.zioaws.s3.model.Tiering]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration = {
    import IntelligentTieringConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .tierings(tierings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration
      .wrap(buildAwsValue())
}
object IntelligentTieringConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration =
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration(
        idValue,
        filterValue.map(value => value.editable),
        statusValue,
        tieringsValue.map { item =>
          item.editable
        }
      )
    def idValue: IntelligentTieringId
    def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter.ReadOnly
    ]
    def statusValue: io.github.vigoo.zioaws.s3.model.IntelligentTieringStatus
    def tieringsValue: List[io.github.vigoo.zioaws.s3.model.Tiering.ReadOnly]
    def id: ZIO[Any, Nothing, IntelligentTieringId] = ZIO.succeed(idValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.IntelligentTieringStatus
    ] = ZIO.succeed(statusValue)
    def tierings: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.Tiering.ReadOnly
    ]] = ZIO.succeed(tieringsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly {
    override def idValue: IntelligentTieringId = impl.id(): IntelligentTieringId
    override def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter.wrap(value)
      )
    override def statusValue
        : io.github.vigoo.zioaws.s3.model.IntelligentTieringStatus =
      io.github.vigoo.zioaws.s3.model.IntelligentTieringStatus
        .wrap(impl.status())
    override def tieringsValue
        : List[io.github.vigoo.zioaws.s3.model.Tiering.ReadOnly] = impl
      .tierings()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.Tiering.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringConfiguration
  ): io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly =
    new Wrapper(impl)
}
