package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Prefix
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IntelligentTieringFilter(
    prefix: Option[Prefix] = None,
    tag: Option[io.github.vigoo.zioaws.s3.model.Tag] = None,
    and: Option[io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IntelligentTieringFilter = {
    import IntelligentTieringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter.ReadOnly =
    io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter
      .wrap(buildAwsValue())
}
object IntelligentTieringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter =
      io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter(
        prefixValue.map(value => value),
        tagValue.map(value => value.editable),
        andValue.map(value => value.editable)
      )
    def prefixValue: Option[Prefix]
    def tagValue: Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]
    def andValue: Option[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator.ReadOnly
    ]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def tag: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tagValue)
    def and: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", andValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
  ) extends io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def tagValue
        : Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] = scala
      .Option(impl.tag())
      .map(value => io.github.vigoo.zioaws.s3.model.Tag.wrap(value))
    override def andValue: Option[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator.ReadOnly
    ] = scala
      .Option(impl.and())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.IntelligentTieringAndOperator
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IntelligentTieringFilter
  ): io.github.vigoo.zioaws.s3.model.IntelligentTieringFilter.ReadOnly =
    new Wrapper(impl)
}
