package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{InventoryId, IsEnabled}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InventoryConfiguration(
    destination: io.github.vigoo.zioaws.s3.model.InventoryDestination,
    isEnabled: IsEnabled,
    filter: Option[io.github.vigoo.zioaws.s3.model.InventoryFilter] = None,
    id: InventoryId,
    includedObjectVersions: io.github.vigoo.zioaws.s3.model.InventoryIncludedObjectVersions,
    optionalFields: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.InventoryOptionalField]
    ] = None,
    schedule: io.github.vigoo.zioaws.s3.model.InventorySchedule
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryConfiguration = {
    import InventoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryConfiguration
      .builder()
      .destination(destination.buildAwsValue())
      .isEnabled(isEnabled: java.lang.Boolean)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .id(id: java.lang.String)
      .includedObjectVersions(includedObjectVersions.unwrap)
      .optionallyWith(
        optionalFields.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.optionalFieldsWithStrings)
      .schedule(schedule.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.InventoryConfiguration.wrap(buildAwsValue())
}
object InventoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.InventoryConfiguration =
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration(
        destinationValue.editable,
        isEnabledValue,
        filterValue.map(value => value.editable),
        idValue,
        includedObjectVersionsValue,
        optionalFieldsValue.map(value => value),
        scheduleValue.editable
      )
    def destinationValue
        : io.github.vigoo.zioaws.s3.model.InventoryDestination.ReadOnly
    def isEnabledValue: IsEnabled
    def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.InventoryFilter.ReadOnly]
    def idValue: InventoryId
    def includedObjectVersionsValue
        : io.github.vigoo.zioaws.s3.model.InventoryIncludedObjectVersions
    def optionalFieldsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.InventoryOptionalField]]
    def scheduleValue
        : io.github.vigoo.zioaws.s3.model.InventorySchedule.ReadOnly
    def destination: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InventoryDestination.ReadOnly
    ] = ZIO.succeed(destinationValue)
    def isEnabled: ZIO[Any, Nothing, IsEnabled] = ZIO.succeed(isEnabledValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.InventoryFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def id: ZIO[Any, Nothing, InventoryId] = ZIO.succeed(idValue)
    def includedObjectVersions: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InventoryIncludedObjectVersions
    ] = ZIO.succeed(includedObjectVersionsValue)
    def optionalFields: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.InventoryOptionalField
    ]] = AwsError.unwrapOptionField("optionalFields", optionalFieldsValue)
    def schedule: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InventorySchedule.ReadOnly
    ] = ZIO.succeed(scheduleValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly {
    override def destinationValue
        : io.github.vigoo.zioaws.s3.model.InventoryDestination.ReadOnly =
      io.github.vigoo.zioaws.s3.model.InventoryDestination
        .wrap(impl.destination())
    override def isEnabledValue: IsEnabled = impl.isEnabled(): IsEnabled
    override def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.InventoryFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.InventoryFilter.wrap(value)
        )
    override def idValue: InventoryId = impl.id(): InventoryId
    override def includedObjectVersionsValue
        : io.github.vigoo.zioaws.s3.model.InventoryIncludedObjectVersions =
      io.github.vigoo.zioaws.s3.model.InventoryIncludedObjectVersions
        .wrap(impl.includedObjectVersions())
    override def optionalFieldsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.InventoryOptionalField]] =
      scala
        .Option(impl.optionalFields())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.InventoryOptionalField.wrap(item)
          }.toList
        )
    override def scheduleValue
        : io.github.vigoo.zioaws.s3.model.InventorySchedule.ReadOnly =
      io.github.vigoo.zioaws.s3.model.InventorySchedule.wrap(impl.schedule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryConfiguration
  ): io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly =
    new Wrapper(impl)
}
