package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InventoryDestination(
    s3BucketDestination: io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryDestination = {
    import InventoryDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryDestination
      .builder()
      .s3BucketDestination(s3BucketDestination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.InventoryDestination.ReadOnly =
    io.github.vigoo.zioaws.s3.model.InventoryDestination.wrap(buildAwsValue())
}
object InventoryDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.InventoryDestination =
      io.github.vigoo.zioaws.s3.model
        .InventoryDestination(s3BucketDestinationValue.editable)
    def s3BucketDestinationValue
        : io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination.ReadOnly
    def s3BucketDestination: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination.ReadOnly
    ] = ZIO.succeed(s3BucketDestinationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryDestination
  ) extends io.github.vigoo.zioaws.s3.model.InventoryDestination.ReadOnly {
    override def s3BucketDestinationValue
        : io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination.ReadOnly =
      io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination
        .wrap(impl.s3BucketDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryDestination
  ): io.github.vigoo.zioaws.s3.model.InventoryDestination.ReadOnly =
    new Wrapper(impl)
}
