package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InventoryEncryption(
    sses3: Option[io.github.vigoo.zioaws.s3.model.SSES3] = None,
    ssekms: Option[io.github.vigoo.zioaws.s3.model.SSEKMS] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryEncryption = {
    import InventoryEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryEncryption
      .builder()
      .optionallyWith(sses3.map(value => value.buildAwsValue()))(_.sses3)
      .optionallyWith(ssekms.map(value => value.buildAwsValue()))(_.ssekms)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.InventoryEncryption.ReadOnly =
    io.github.vigoo.zioaws.s3.model.InventoryEncryption.wrap(buildAwsValue())
}
object InventoryEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.InventoryEncryption =
      io.github.vigoo.zioaws.s3.model.InventoryEncryption(
        sses3Value.map(value => value.editable),
        ssekmsValue.map(value => value.editable)
      )
    def sses3Value: Option[io.github.vigoo.zioaws.s3.model.SSES3.ReadOnly]
    def ssekmsValue: Option[io.github.vigoo.zioaws.s3.model.SSEKMS.ReadOnly]
    def sses3
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.SSES3.ReadOnly] =
      AwsError.unwrapOptionField("sses3", sses3Value)
    def ssekms
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.SSEKMS.ReadOnly] =
      AwsError.unwrapOptionField("ssekms", ssekmsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryEncryption
  ) extends io.github.vigoo.zioaws.s3.model.InventoryEncryption.ReadOnly {
    override def sses3Value
        : Option[io.github.vigoo.zioaws.s3.model.SSES3.ReadOnly] = scala
      .Option(impl.sses3())
      .map(value => io.github.vigoo.zioaws.s3.model.SSES3.wrap(value))
    override def ssekmsValue
        : Option[io.github.vigoo.zioaws.s3.model.SSEKMS.ReadOnly] = scala
      .Option(impl.ssekms())
      .map(value => io.github.vigoo.zioaws.s3.model.SSEKMS.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryEncryption
  ): io.github.vigoo.zioaws.s3.model.InventoryEncryption.ReadOnly = new Wrapper(
    impl
  )
}
