package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Prefix
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InventoryFilter(prefix: Prefix) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryFilter = {
    import InventoryFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryFilter
      .builder()
      .prefix(prefix: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.InventoryFilter.ReadOnly =
    io.github.vigoo.zioaws.s3.model.InventoryFilter.wrap(buildAwsValue())
}
object InventoryFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.InventoryFilter =
      io.github.vigoo.zioaws.s3.model.InventoryFilter(prefixValue)
    def prefixValue: Prefix
    def prefix: ZIO[Any, Nothing, Prefix] = ZIO.succeed(prefixValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryFilter
  ) extends io.github.vigoo.zioaws.s3.model.InventoryFilter.ReadOnly {
    override def prefixValue: Prefix = impl.prefix(): Prefix
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryFilter
  ): io.github.vigoo.zioaws.s3.model.InventoryFilter.ReadOnly = new Wrapper(
    impl
  )
}
