package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait InventoryFrequency {
  def unwrap: software.amazon.awssdk.services.s3.model.InventoryFrequency
}
object InventoryFrequency {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.InventoryFrequency
  ): io.github.vigoo.zioaws.s3.model.InventoryFrequency = value match {
    case software.amazon.awssdk.services.s3.model.InventoryFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.InventoryFrequency.DAILY =>
      val r = Daily
      r
    case software.amazon.awssdk.services.s3.model.InventoryFrequency.WEEKLY =>
      val r = Weekly
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.InventoryFrequency {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryFrequency =
      software.amazon.awssdk.services.s3.model.InventoryFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object Daily extends io.github.vigoo.zioaws.s3.model.InventoryFrequency {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryFrequency =
      software.amazon.awssdk.services.s3.model.InventoryFrequency.DAILY
  }
  case object Weekly
      extends io.github.vigoo.zioaws.s3.model.InventoryFrequency {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryFrequency =
      software.amazon.awssdk.services.s3.model.InventoryFrequency.WEEKLY
  }
}
