package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  Prefix,
  BucketName,
  AccountId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InventoryS3BucketDestination(
    accountId: Option[AccountId] = None,
    bucket: BucketName,
    format: io.github.vigoo.zioaws.s3.model.InventoryFormat,
    prefix: Option[Prefix] = None,
    encryption: Option[io.github.vigoo.zioaws.s3.model.InventoryEncryption] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination = {
    import InventoryS3BucketDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .bucket(bucket: java.lang.String)
      .format(format.unwrap)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination.ReadOnly =
    io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination
      .wrap(buildAwsValue())
}
object InventoryS3BucketDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination =
      io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination(
        accountIdValue.map(value => value),
        bucketValue,
        formatValue,
        prefixValue.map(value => value),
        encryptionValue.map(value => value.editable)
      )
    def accountIdValue: Option[AccountId]
    def bucketValue: BucketName
    def formatValue: io.github.vigoo.zioaws.s3.model.InventoryFormat
    def prefixValue: Option[Prefix]
    def encryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.InventoryEncryption.ReadOnly]
    def accountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountIdValue)
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def format
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.InventoryFormat] =
      ZIO.succeed(formatValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def encryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.InventoryEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryptionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
  ) extends io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination.ReadOnly {
    override def accountIdValue: Option[AccountId] =
      scala.Option(impl.accountId()).map(value => value: AccountId)
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def formatValue: io.github.vigoo.zioaws.s3.model.InventoryFormat =
      io.github.vigoo.zioaws.s3.model.InventoryFormat.wrap(impl.format())
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def encryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.InventoryEncryption.ReadOnly] =
      scala
        .Option(impl.encryption())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.InventoryEncryption.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination
  ): io.github.vigoo.zioaws.s3.model.InventoryS3BucketDestination.ReadOnly =
    new Wrapper(impl)
}
