package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InventorySchedule(
    frequency: io.github.vigoo.zioaws.s3.model.InventoryFrequency
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventorySchedule = {
    import InventorySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventorySchedule
      .builder()
      .frequency(frequency.unwrap)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.InventorySchedule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.InventorySchedule.wrap(buildAwsValue())
}
object InventorySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventorySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.InventorySchedule =
      io.github.vigoo.zioaws.s3.model.InventorySchedule(frequencyValue)
    def frequencyValue: io.github.vigoo.zioaws.s3.model.InventoryFrequency
    def frequency: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InventoryFrequency
    ] = ZIO.succeed(frequencyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventorySchedule
  ) extends io.github.vigoo.zioaws.s3.model.InventorySchedule.ReadOnly {
    override def frequencyValue
        : io.github.vigoo.zioaws.s3.model.InventoryFrequency =
      io.github.vigoo.zioaws.s3.model.InventoryFrequency.wrap(impl.frequency())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventorySchedule
  ): io.github.vigoo.zioaws.s3.model.InventorySchedule.ReadOnly = new Wrapper(
    impl
  )
}
