package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JSONInput(
    `type`: Option[io.github.vigoo.zioaws.s3.model.JSONType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.JSONInput = {
    import JSONInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.JSONInput
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.JSONInput.ReadOnly =
    io.github.vigoo.zioaws.s3.model.JSONInput.wrap(buildAwsValue())
}
object JSONInput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.JSONInput] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.JSONInput =
      io.github.vigoo.zioaws.s3.model.JSONInput(typeValue.map(value => value))
    def typeValue: Option[io.github.vigoo.zioaws.s3.model.JSONType]
    def `type`: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.JSONType] =
      AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.JSONInput
  ) extends io.github.vigoo.zioaws.s3.model.JSONInput.ReadOnly {
    override def typeValue: Option[io.github.vigoo.zioaws.s3.model.JSONType] =
      scala
        .Option(impl.`type`())
        .map(value => io.github.vigoo.zioaws.s3.model.JSONType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.JSONInput
  ): io.github.vigoo.zioaws.s3.model.JSONInput.ReadOnly = new Wrapper(impl)
}
