package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.RecordDelimiter
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JSONOutput(recordDelimiter: Option[RecordDelimiter] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.JSONOutput = {
    import JSONOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.JSONOutput
      .builder()
      .optionallyWith(recordDelimiter.map(value => value: java.lang.String))(
        _.recordDelimiter
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.JSONOutput.ReadOnly =
    io.github.vigoo.zioaws.s3.model.JSONOutput.wrap(buildAwsValue())
}
object JSONOutput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.JSONOutput] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.JSONOutput =
      io.github.vigoo.zioaws.s3.model
        .JSONOutput(recordDelimiterValue.map(value => value))
    def recordDelimiterValue: Option[RecordDelimiter]
    def recordDelimiter: ZIO[Any, AwsError, RecordDelimiter] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.JSONOutput
  ) extends io.github.vigoo.zioaws.s3.model.JSONOutput.ReadOnly {
    override def recordDelimiterValue: Option[RecordDelimiter] =
      scala.Option(impl.recordDelimiter()).map(value => value: RecordDelimiter)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.JSONOutput
  ): io.github.vigoo.zioaws.s3.model.JSONOutput.ReadOnly = new Wrapper(impl)
}
