package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait JSONType {
  def unwrap: software.amazon.awssdk.services.s3.model.JSONType
}
object JSONType {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.JSONType
  ): io.github.vigoo.zioaws.s3.model.JSONType = value match {
    case software.amazon.awssdk.services.s3.model.JSONType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.JSONType.DOCUMENT =>
      val r = DOCUMENT
      r
    case software.amazon.awssdk.services.s3.model.JSONType.LINES =>
      val r = LINES
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.JSONType {
    override def unwrap: software.amazon.awssdk.services.s3.model.JSONType =
      software.amazon.awssdk.services.s3.model.JSONType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOCUMENT extends io.github.vigoo.zioaws.s3.model.JSONType {
    override def unwrap: software.amazon.awssdk.services.s3.model.JSONType =
      software.amazon.awssdk.services.s3.model.JSONType.DOCUMENT
  }
  case object LINES extends io.github.vigoo.zioaws.s3.model.JSONType {
    override def unwrap: software.amazon.awssdk.services.s3.model.JSONType =
      software.amazon.awssdk.services.s3.model.JSONType.LINES
  }
}
