package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  LambdaFunctionArn,
  NotificationId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LambdaFunctionConfiguration(
    id: Option[NotificationId] = None,
    lambdaFunctionArn: LambdaFunctionArn,
    events: Iterable[io.github.vigoo.zioaws.s3.model.Event],
    filter: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration = {
    import LambdaFunctionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .lambdaFunctionArn(lambdaFunctionArn: java.lang.String)
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration
      .wrap(buildAwsValue())
}
object LambdaFunctionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration =
      io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration(
        idValue.map(value => value),
        lambdaFunctionArnValue,
        eventsValue,
        filterValue.map(value => value.editable)
      )
    def idValue: Option[NotificationId]
    def lambdaFunctionArnValue: LambdaFunctionArn
    def eventsValue: List[io.github.vigoo.zioaws.s3.model.Event]
    def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ]
    def id: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("id", idValue)
    def lambdaFunctionArn: ZIO[Any, Nothing, LambdaFunctionArn] =
      ZIO.succeed(lambdaFunctionArnValue)
    def events: ZIO[Any, Nothing, List[io.github.vigoo.zioaws.s3.model.Event]] =
      ZIO.succeed(eventsValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration.ReadOnly {
    override def idValue: Option[NotificationId] =
      scala.Option(impl.id()).map(value => value: NotificationId)
    override def lambdaFunctionArnValue: LambdaFunctionArn =
      impl.lambdaFunctionArn(): LambdaFunctionArn
    override def eventsValue: List[io.github.vigoo.zioaws.s3.model.Event] = impl
      .events()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.Event.wrap(item)
      }
      .toList
    override def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
  ): io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration.ReadOnly =
    new Wrapper(impl)
}
