package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{
  ExpiredObjectDeleteMarker,
  Days,
  Date
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LifecycleExpiration(
    date: Option[Date] = None,
    days: Option[Days] = None,
    expiredObjectDeleteMarker: Option[ExpiredObjectDeleteMarker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleExpiration = {
    import LifecycleExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleExpiration
      .builder()
      .optionallyWith(date.map(value => value: Instant))(_.date)
      .optionallyWith(days.map(value => value: Integer))(_.days)
      .optionallyWith(
        expiredObjectDeleteMarker.map(value => value: java.lang.Boolean)
      )(_.expiredObjectDeleteMarker)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.LifecycleExpiration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.LifecycleExpiration.wrap(buildAwsValue())
}
object LifecycleExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LifecycleExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.LifecycleExpiration =
      io.github.vigoo.zioaws.s3.model.LifecycleExpiration(
        dateValue.map(value => value),
        daysValue.map(value => value),
        expiredObjectDeleteMarkerValue.map(value => value)
      )
    def dateValue: Option[Date]
    def daysValue: Option[Days]
    def expiredObjectDeleteMarkerValue: Option[ExpiredObjectDeleteMarker]
    def date: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("date", dateValue)
    def days: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", daysValue)
    def expiredObjectDeleteMarker
        : ZIO[Any, AwsError, ExpiredObjectDeleteMarker] =
      AwsError.unwrapOptionField(
        "expiredObjectDeleteMarker",
        expiredObjectDeleteMarkerValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleExpiration
  ) extends io.github.vigoo.zioaws.s3.model.LifecycleExpiration.ReadOnly {
    override def dateValue: Option[Date] =
      scala.Option(impl.date()).map(value => value: Date)
    override def daysValue: Option[Days] =
      scala.Option(impl.days()).map(value => value: Days)
    override def expiredObjectDeleteMarkerValue
        : Option[ExpiredObjectDeleteMarker] = scala
      .Option(impl.expiredObjectDeleteMarker())
      .map(value => value: ExpiredObjectDeleteMarker)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleExpiration
  ): io.github.vigoo.zioaws.s3.model.LifecycleExpiration.ReadOnly = new Wrapper(
    impl
  )
}
