package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{Prefix, ID}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LifecycleRule(
    expiration: Option[io.github.vigoo.zioaws.s3.model.LifecycleExpiration] =
      None,
    id: Option[ID] = None,
    prefix: Option[Prefix] = None,
    filter: Option[io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter] = None,
    status: io.github.vigoo.zioaws.s3.model.ExpirationStatus,
    transitions: Option[Iterable[io.github.vigoo.zioaws.s3.model.Transition]] =
      None,
    noncurrentVersionTransitions: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition]
    ] = None,
    noncurrentVersionExpiration: Option[
      io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration
    ] = None,
    abortIncompleteMultipartUpload: Option[
      io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRule = {
    import LifecycleRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRule
      .builder()
      .optionallyWith(expiration.map(value => value.buildAwsValue()))(
        _.expiration
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .optionallyWith(
        transitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitions)
      .optionallyWith(
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noncurrentVersionTransitions)
      .optionallyWith(
        noncurrentVersionExpiration.map(value => value.buildAwsValue())
      )(_.noncurrentVersionExpiration)
      .optionallyWith(
        abortIncompleteMultipartUpload.map(value => value.buildAwsValue())
      )(_.abortIncompleteMultipartUpload)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.LifecycleRule.wrap(buildAwsValue())
}
object LifecycleRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.LifecycleRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.LifecycleRule =
      io.github.vigoo.zioaws.s3.model.LifecycleRule(
        expirationValue.map(value => value.editable),
        idValue.map(value => value),
        prefixValue.map(value => value),
        filterValue.map(value => value.editable),
        statusValue,
        transitionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        noncurrentVersionTransitionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        noncurrentVersionExpirationValue.map(value => value.editable),
        abortIncompleteMultipartUploadValue.map(value => value.editable)
      )
    def expirationValue
        : Option[io.github.vigoo.zioaws.s3.model.LifecycleExpiration.ReadOnly]
    def idValue: Option[ID]
    def prefixValue: Option[Prefix]
    def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.ReadOnly]
    def statusValue: io.github.vigoo.zioaws.s3.model.ExpirationStatus
    def transitionsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Transition.ReadOnly]]
    def noncurrentVersionTransitionsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition.ReadOnly]
    ]
    def noncurrentVersionExpirationValue: Option[
      io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration.ReadOnly
    ]
    def abortIncompleteMultipartUploadValue: Option[
      io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload.ReadOnly
    ]
    def expiration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.LifecycleExpiration.ReadOnly
    ] = AwsError.unwrapOptionField("expiration", expirationValue)
    def id: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", idValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def status
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.ExpirationStatus] =
      ZIO.succeed(statusValue)
    def transitions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Transition.ReadOnly
    ]] = AwsError.unwrapOptionField("transitions", transitionsValue)
    def noncurrentVersionTransitions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "noncurrentVersionTransitions",
      noncurrentVersionTransitionsValue
    )
    def noncurrentVersionExpiration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "noncurrentVersionExpiration",
      noncurrentVersionExpirationValue
    )
    def abortIncompleteMultipartUpload: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload.ReadOnly
    ] = AwsError.unwrapOptionField(
      "abortIncompleteMultipartUpload",
      abortIncompleteMultipartUploadValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRule
  ) extends io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly {
    override def expirationValue
        : Option[io.github.vigoo.zioaws.s3.model.LifecycleExpiration.ReadOnly] =
      scala
        .Option(impl.expiration())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.LifecycleExpiration.wrap(value)
        )
    override def idValue: Option[ID] =
      scala.Option(impl.id()).map(value => value: ID)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.wrap(value)
        )
    override def statusValue: io.github.vigoo.zioaws.s3.model.ExpirationStatus =
      io.github.vigoo.zioaws.s3.model.ExpirationStatus.wrap(impl.status())
    override def transitionsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Transition.ReadOnly]] =
      scala
        .Option(impl.transitions())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.Transition.wrap(item)
          }.toList
        )
    override def noncurrentVersionTransitionsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition.ReadOnly]
    ] = scala
      .Option(impl.noncurrentVersionTransitions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition.wrap(item)
        }.toList
      )
    override def noncurrentVersionExpirationValue: Option[
      io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration.ReadOnly
    ] = scala
      .Option(impl.noncurrentVersionExpiration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration.wrap(value)
      )
    override def abortIncompleteMultipartUploadValue: Option[
      io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload.ReadOnly
    ] = scala
      .Option(impl.abortIncompleteMultipartUpload())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRule
  ): io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly = new Wrapper(impl)
}
