package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ObjectSizeLessThanBytes,
  ObjectSizeGreaterThanBytes,
  Prefix
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LifecycleRuleAndOperator(
    prefix: Option[Prefix] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.s3.model.Tag]] = None,
    objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes] = None,
    objectSizeLessThan: Option[ObjectSizeLessThanBytes] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator = {
    import LifecycleRuleAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        objectSizeGreaterThan.map(value => value: java.lang.Long)
      )(_.objectSizeGreaterThan)
      .optionallyWith(objectSizeLessThan.map(value => value: java.lang.Long))(
        _.objectSizeLessThan
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator.ReadOnly =
    io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator
      .wrap(buildAwsValue())
}
object LifecycleRuleAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator =
      io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator(
        prefixValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        objectSizeGreaterThanValue.map(value => value),
        objectSizeLessThanValue.map(value => value)
      )
    def prefixValue: Option[Prefix]
    def tagsValue: Option[List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]]
    def objectSizeGreaterThanValue: Option[ObjectSizeGreaterThanBytes]
    def objectSizeLessThanValue: Option[ObjectSizeLessThanBytes]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def objectSizeGreaterThan: ZIO[Any, AwsError, ObjectSizeGreaterThanBytes] =
      AwsError.unwrapOptionField(
        "objectSizeGreaterThan",
        objectSizeGreaterThanValue
      )
    def objectSizeLessThan: ZIO[Any, AwsError, ObjectSizeLessThanBytes] =
      AwsError.unwrapOptionField("objectSizeLessThan", objectSizeLessThanValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ) extends io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Tag.wrap(item)
        }.toList
      )
    override def objectSizeGreaterThanValue
        : Option[ObjectSizeGreaterThanBytes] = scala
      .Option(impl.objectSizeGreaterThan())
      .map(value => value: ObjectSizeGreaterThanBytes)
    override def objectSizeLessThanValue: Option[ObjectSizeLessThanBytes] =
      scala
        .Option(impl.objectSizeLessThan())
        .map(value => value: ObjectSizeLessThanBytes)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ): io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator.ReadOnly =
    new Wrapper(impl)
}
