package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ObjectSizeLessThanBytes,
  ObjectSizeGreaterThanBytes,
  Prefix
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LifecycleRuleFilter(
    prefix: Option[Prefix] = None,
    tag: Option[io.github.vigoo.zioaws.s3.model.Tag] = None,
    objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes] = None,
    objectSizeLessThan: Option[ObjectSizeLessThanBytes] = None,
    and: Option[io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRuleFilter = {
    import LifecycleRuleFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(
        objectSizeGreaterThan.map(value => value: java.lang.Long)
      )(_.objectSizeGreaterThan)
      .optionallyWith(objectSizeLessThan.map(value => value: java.lang.Long))(
        _.objectSizeLessThan
      )
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.ReadOnly =
    io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.wrap(buildAwsValue())
}
object LifecycleRuleFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter =
      io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter(
        prefixValue.map(value => value),
        tagValue.map(value => value.editable),
        objectSizeGreaterThanValue.map(value => value),
        objectSizeLessThanValue.map(value => value),
        andValue.map(value => value.editable)
      )
    def prefixValue: Option[Prefix]
    def tagValue: Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]
    def objectSizeGreaterThanValue: Option[ObjectSizeGreaterThanBytes]
    def objectSizeLessThanValue: Option[ObjectSizeLessThanBytes]
    def andValue: Option[
      io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator.ReadOnly
    ]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def tag: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tagValue)
    def objectSizeGreaterThan: ZIO[Any, AwsError, ObjectSizeGreaterThanBytes] =
      AwsError.unwrapOptionField(
        "objectSizeGreaterThan",
        objectSizeGreaterThanValue
      )
    def objectSizeLessThan: ZIO[Any, AwsError, ObjectSizeLessThanBytes] =
      AwsError.unwrapOptionField("objectSizeLessThan", objectSizeLessThanValue)
    def and: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", andValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
  ) extends io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def tagValue
        : Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] = scala
      .Option(impl.tag())
      .map(value => io.github.vigoo.zioaws.s3.model.Tag.wrap(value))
    override def objectSizeGreaterThanValue
        : Option[ObjectSizeGreaterThanBytes] = scala
      .Option(impl.objectSizeGreaterThan())
      .map(value => value: ObjectSizeGreaterThanBytes)
    override def objectSizeLessThanValue: Option[ObjectSizeLessThanBytes] =
      scala
        .Option(impl.objectSizeLessThan())
        .map(value => value: ObjectSizeLessThanBytes)
    override def andValue: Option[
      io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator.ReadOnly
    ] = scala
      .Option(impl.and())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.LifecycleRuleAndOperator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleFilter
  ): io.github.vigoo.zioaws.s3.model.LifecycleRuleFilter.ReadOnly = new Wrapper(
    impl
  )
}
