package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccountId, Token, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBucketAnalyticsConfigurationsRequest(
    bucket: BucketName,
    continuationToken: Option[Token] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest = {
    import ListBucketAnalyticsConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListBucketAnalyticsConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest =
      io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest(
        bucketValue,
        continuationTokenValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def continuationTokenValue: Option[Token]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
  ) extends io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest
  ): io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
