package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  NextToken,
  Token,
  IsTruncated
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBucketAnalyticsConfigurationsResponse(
    isTruncated: Option[IsTruncated] = None,
    continuationToken: Option[Token] = None,
    nextContinuationToken: Option[NextToken] = None,
    analyticsConfigurationList: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse = {
    import ListBucketAnalyticsConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
      .builder()
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .optionallyWith(
        nextContinuationToken.map(value => value: java.lang.String)
      )(_.nextContinuationToken)
      .optionallyWith(
        analyticsConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.analyticsConfigurationList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketAnalyticsConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse =
      io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse(
        isTruncatedValue.map(value => value),
        continuationTokenValue.map(value => value),
        nextContinuationTokenValue.map(value => value),
        analyticsConfigurationListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def isTruncatedValue: Option[IsTruncated]
    def continuationTokenValue: Option[Token]
    def nextContinuationTokenValue: Option[NextToken]
    def analyticsConfigurationListValue: Option[
      List[io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly]
    ]
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
    def nextContinuationToken: ZIO[Any, AwsError, NextToken] = AwsError
      .unwrapOptionField("nextContinuationToken", nextContinuationTokenValue)
    def analyticsConfigurationList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "analyticsConfigurationList",
      analyticsConfigurationListValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly {
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
    override def nextContinuationTokenValue: Option[NextToken] =
      scala.Option(impl.nextContinuationToken()).map(value => value: NextToken)
    override def analyticsConfigurationListValue: Option[
      List[io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly]
    ] = scala
      .Option(impl.analyticsConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
  ): io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
