package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{Token, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBucketIntelligentTieringConfigurationsRequest(
    bucket: BucketName,
    continuationToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest = {
    import ListBucketIntelligentTieringConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListBucketIntelligentTieringConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest =
      io.github.vigoo.zioaws.s3.model
        .ListBucketIntelligentTieringConfigurationsRequest(
          bucketValue,
          continuationTokenValue.map(value => value)
        )
    def bucketValue: BucketName
    def continuationTokenValue: Option[Token]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
  ) extends io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsRequest
  ): io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
