package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  NextToken,
  Token,
  IsTruncated
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBucketIntelligentTieringConfigurationsResponse(
    isTruncated: Option[IsTruncated] = None,
    continuationToken: Option[Token] = None,
    nextContinuationToken: Option[NextToken] = None,
    intelligentTieringConfigurationList: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse = {
    import ListBucketIntelligentTieringConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
      .builder()
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .optionallyWith(
        nextContinuationToken.map(value => value: java.lang.String)
      )(_.nextContinuationToken)
      .optionallyWith(
        intelligentTieringConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.intelligentTieringConfigurationList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketIntelligentTieringConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse =
      io.github.vigoo.zioaws.s3.model
        .ListBucketIntelligentTieringConfigurationsResponse(
          isTruncatedValue.map(value => value),
          continuationTokenValue.map(value => value),
          nextContinuationTokenValue.map(value => value),
          intelligentTieringConfigurationListValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def isTruncatedValue: Option[IsTruncated]
    def continuationTokenValue: Option[Token]
    def nextContinuationTokenValue: Option[NextToken]
    def intelligentTieringConfigurationListValue: Option[List[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ]]
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
    def nextContinuationToken: ZIO[Any, AwsError, NextToken] = AwsError
      .unwrapOptionField("nextContinuationToken", nextContinuationTokenValue)
    def intelligentTieringConfigurationList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "intelligentTieringConfigurationList",
      intelligentTieringConfigurationListValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly {
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
    override def nextContinuationTokenValue: Option[NextToken] =
      scala.Option(impl.nextContinuationToken()).map(value => value: NextToken)
    override def intelligentTieringConfigurationListValue: Option[List[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ]] = scala
      .Option(impl.intelligentTieringConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
  ): io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
