package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  NextToken,
  IsTruncated,
  Token
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBucketInventoryConfigurationsResponse(
    continuationToken: Option[Token] = None,
    inventoryConfigurationList: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.InventoryConfiguration]
    ] = None,
    isTruncated: Option[IsTruncated] = None,
    nextContinuationToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse = {
    import ListBucketInventoryConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
      .builder()
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .optionallyWith(
        inventoryConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inventoryConfigurationList)
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(
        nextContinuationToken.map(value => value: java.lang.String)
      )(_.nextContinuationToken)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketInventoryConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse =
      io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse(
        continuationTokenValue.map(value => value),
        inventoryConfigurationListValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        isTruncatedValue.map(value => value),
        nextContinuationTokenValue.map(value => value)
      )
    def continuationTokenValue: Option[Token]
    def inventoryConfigurationListValue: Option[
      List[io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly]
    ]
    def isTruncatedValue: Option[IsTruncated]
    def nextContinuationTokenValue: Option[NextToken]
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
    def inventoryConfigurationList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inventoryConfigurationList",
      inventoryConfigurationListValue
    )
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def nextContinuationToken: ZIO[Any, AwsError, NextToken] = AwsError
      .unwrapOptionField("nextContinuationToken", nextContinuationTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly {
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
    override def inventoryConfigurationListValue: Option[
      List[io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly]
    ] = scala
      .Option(impl.inventoryConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.InventoryConfiguration.wrap(item)
        }.toList
      )
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def nextContinuationTokenValue: Option[NextToken] =
      scala.Option(impl.nextContinuationToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse
  ): io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
