package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  NextToken,
  Token,
  IsTruncated
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBucketMetricsConfigurationsResponse(
    isTruncated: Option[IsTruncated] = None,
    continuationToken: Option[Token] = None,
    nextContinuationToken: Option[NextToken] = None,
    metricsConfigurationList: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.MetricsConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse = {
    import ListBucketMetricsConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
      .builder()
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .optionallyWith(
        nextContinuationToken.map(value => value: java.lang.String)
      )(_.nextContinuationToken)
      .optionallyWith(
        metricsConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricsConfigurationList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketMetricsConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse =
      io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse(
        isTruncatedValue.map(value => value),
        continuationTokenValue.map(value => value),
        nextContinuationTokenValue.map(value => value),
        metricsConfigurationListValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def isTruncatedValue: Option[IsTruncated]
    def continuationTokenValue: Option[Token]
    def nextContinuationTokenValue: Option[NextToken]
    def metricsConfigurationListValue: Option[
      List[io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly]
    ]
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
    def nextContinuationToken: ZIO[Any, AwsError, NextToken] = AwsError
      .unwrapOptionField("nextContinuationToken", nextContinuationTokenValue)
    def metricsConfigurationList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "metricsConfigurationList",
      metricsConfigurationListValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly {
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
    override def nextContinuationTokenValue: Option[NextToken] =
      scala.Option(impl.nextContinuationToken()).map(value => value: NextToken)
    override def metricsConfigurationListValue: Option[
      List[io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly]
    ] = scala
      .Option(impl.metricsConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.MetricsConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse
  ): io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
