package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBucketsResponse(
    buckets: Option[Iterable[io.github.vigoo.zioaws.s3.model.Bucket]] = None,
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketsResponse = {
    import ListBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListBucketsResponse.wrap(buildAwsValue())
}
object ListBucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListBucketsResponse =
      io.github.vigoo.zioaws.s3.model.ListBucketsResponse(
        bucketsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        ownerValue.map(value => value.editable)
      )
    def bucketsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Bucket.ReadOnly]]
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def buckets: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Bucket.ReadOnly
    ]] = AwsError.unwrapOptionField("buckets", bucketsValue)
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly {
    override def bucketsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Bucket.ReadOnly]] = scala
      .Option(impl.buckets())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Bucket.wrap(item)
        }.toList
      )
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketsResponse
  ): io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly = new Wrapper(
    impl
  )
}
