package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  Prefix,
  AccountId,
  MaxUploads,
  Delimiter,
  BucketName,
  KeyMarker,
  UploadIdMarker
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMultipartUploadsRequest(
    bucket: BucketName,
    delimiter: Option[Delimiter] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None,
    keyMarker: Option[KeyMarker] = None,
    maxUploads: Option[MaxUploads] = None,
    prefix: Option[Prefix] = None,
    uploadIdMarker: Option[UploadIdMarker] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest = {
    import ListMultipartUploadsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(keyMarker.map(value => value: java.lang.String))(
        _.keyMarker
      )
      .optionallyWith(maxUploads.map(value => value: Integer))(_.maxUploads)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(uploadIdMarker.map(value => value: java.lang.String))(
        _.uploadIdMarker
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest
      .wrap(buildAwsValue())
}
object ListMultipartUploadsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest =
      io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest(
        bucketValue,
        delimiterValue.map(value => value),
        encodingTypeValue.map(value => value),
        keyMarkerValue.map(value => value),
        maxUploadsValue.map(value => value),
        prefixValue.map(value => value),
        uploadIdMarkerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def delimiterValue: Option[Delimiter]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def keyMarkerValue: Option[KeyMarker]
    def maxUploadsValue: Option[MaxUploads]
    def prefixValue: Option[Prefix]
    def uploadIdMarkerValue: Option[UploadIdMarker]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
    def keyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarkerValue)
    def maxUploads: ZIO[Any, AwsError, MaxUploads] =
      AwsError.unwrapOptionField("maxUploads", maxUploadsValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def uploadIdMarker: ZIO[Any, AwsError, UploadIdMarker] =
      AwsError.unwrapOptionField("uploadIdMarker", uploadIdMarkerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
  ) extends io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
    override def keyMarkerValue: Option[KeyMarker] =
      scala.Option(impl.keyMarker()).map(value => value: KeyMarker)
    override def maxUploadsValue: Option[MaxUploads] =
      scala.Option(impl.maxUploads()).map(value => value: MaxUploads)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def uploadIdMarkerValue: Option[UploadIdMarker] =
      scala.Option(impl.uploadIdMarker()).map(value => value: UploadIdMarker)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
  ): io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest.ReadOnly =
    new Wrapper(impl)
}
