package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  Prefix,
  MaxUploads,
  Delimiter,
  BucketName,
  KeyMarker,
  IsTruncated,
  NextKeyMarker,
  NextUploadIdMarker,
  UploadIdMarker
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMultipartUploadsResponse(
    bucket: Option[BucketName] = None,
    keyMarker: Option[KeyMarker] = None,
    uploadIdMarker: Option[UploadIdMarker] = None,
    nextKeyMarker: Option[NextKeyMarker] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    nextUploadIdMarker: Option[NextUploadIdMarker] = None,
    maxUploads: Option[MaxUploads] = None,
    isTruncated: Option[IsTruncated] = None,
    uploads: Option[Iterable[io.github.vigoo.zioaws.s3.model.MultipartUpload]] =
      None,
    commonPrefixes: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.CommonPrefix]
    ] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse = {
    import ListMultipartUploadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(keyMarker.map(value => value: java.lang.String))(
        _.keyMarker
      )
      .optionallyWith(uploadIdMarker.map(value => value: java.lang.String))(
        _.uploadIdMarker
      )
      .optionallyWith(nextKeyMarker.map(value => value: java.lang.String))(
        _.nextKeyMarker
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(nextUploadIdMarker.map(value => value: java.lang.String))(
        _.nextUploadIdMarker
      )
      .optionallyWith(maxUploads.map(value => value: Integer))(_.maxUploads)
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(
        uploads.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploads)
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListMultipartUploadsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListMultipartUploadsResponse
      .wrap(buildAwsValue())
}
object ListMultipartUploadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListMultipartUploadsResponse =
      io.github.vigoo.zioaws.s3.model.ListMultipartUploadsResponse(
        bucketValue.map(value => value),
        keyMarkerValue.map(value => value),
        uploadIdMarkerValue.map(value => value),
        nextKeyMarkerValue.map(value => value),
        prefixValue.map(value => value),
        delimiterValue.map(value => value),
        nextUploadIdMarkerValue.map(value => value),
        maxUploadsValue.map(value => value),
        isTruncatedValue.map(value => value),
        uploadsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        commonPrefixesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        encodingTypeValue.map(value => value)
      )
    def bucketValue: Option[BucketName]
    def keyMarkerValue: Option[KeyMarker]
    def uploadIdMarkerValue: Option[UploadIdMarker]
    def nextKeyMarkerValue: Option[NextKeyMarker]
    def prefixValue: Option[Prefix]
    def delimiterValue: Option[Delimiter]
    def nextUploadIdMarkerValue: Option[NextUploadIdMarker]
    def maxUploadsValue: Option[MaxUploads]
    def isTruncatedValue: Option[IsTruncated]
    def uploadsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly]]
    def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def bucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucketValue)
    def keyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarkerValue)
    def uploadIdMarker: ZIO[Any, AwsError, UploadIdMarker] =
      AwsError.unwrapOptionField("uploadIdMarker", uploadIdMarkerValue)
    def nextKeyMarker: ZIO[Any, AwsError, NextKeyMarker] =
      AwsError.unwrapOptionField("nextKeyMarker", nextKeyMarkerValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def nextUploadIdMarker: ZIO[Any, AwsError, NextUploadIdMarker] =
      AwsError.unwrapOptionField("nextUploadIdMarker", nextUploadIdMarkerValue)
    def maxUploads: ZIO[Any, AwsError, MaxUploads] =
      AwsError.unwrapOptionField("maxUploads", maxUploadsValue)
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def uploads: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly
    ]] = AwsError.unwrapOptionField("uploads", uploadsValue)
    def commonPrefixes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField("commonPrefixes", commonPrefixesValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListMultipartUploadsResponse.ReadOnly {
    override def bucketValue: Option[BucketName] =
      scala.Option(impl.bucket()).map(value => value: BucketName)
    override def keyMarkerValue: Option[KeyMarker] =
      scala.Option(impl.keyMarker()).map(value => value: KeyMarker)
    override def uploadIdMarkerValue: Option[UploadIdMarker] =
      scala.Option(impl.uploadIdMarker()).map(value => value: UploadIdMarker)
    override def nextKeyMarkerValue: Option[NextKeyMarker] =
      scala.Option(impl.nextKeyMarker()).map(value => value: NextKeyMarker)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def nextUploadIdMarkerValue: Option[NextUploadIdMarker] = scala
      .Option(impl.nextUploadIdMarker())
      .map(value => value: NextUploadIdMarker)
    override def maxUploadsValue: Option[MaxUploads] =
      scala.Option(impl.maxUploads()).map(value => value: MaxUploads)
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def uploadsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly]
    ] = scala
      .Option(impl.uploads())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.MultipartUpload.wrap(item)
        }.toList
      )
    override def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]] =
      scala
        .Option(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ): io.github.vigoo.zioaws.s3.model.ListMultipartUploadsResponse.ReadOnly =
    new Wrapper(impl)
}
