package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  MaxKeys,
  Prefix,
  AccountId,
  VersionIdMarker,
  Delimiter,
  BucketName,
  KeyMarker
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListObjectVersionsRequest(
    bucket: BucketName,
    delimiter: Option[Delimiter] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None,
    keyMarker: Option[KeyMarker] = None,
    maxKeys: Option[MaxKeys] = None,
    prefix: Option[Prefix] = None,
    versionIdMarker: Option[VersionIdMarker] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest = {
    import ListObjectVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(keyMarker.map(value => value: java.lang.String))(
        _.keyMarker
      )
      .optionallyWith(maxKeys.map(value => value: Integer))(_.maxKeys)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(versionIdMarker.map(value => value: java.lang.String))(
        _.versionIdMarker
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest
      .wrap(buildAwsValue())
}
object ListObjectVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest =
      io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest(
        bucketValue,
        delimiterValue.map(value => value),
        encodingTypeValue.map(value => value),
        keyMarkerValue.map(value => value),
        maxKeysValue.map(value => value),
        prefixValue.map(value => value),
        versionIdMarkerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def delimiterValue: Option[Delimiter]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def keyMarkerValue: Option[KeyMarker]
    def maxKeysValue: Option[MaxKeys]
    def prefixValue: Option[Prefix]
    def versionIdMarkerValue: Option[VersionIdMarker]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
    def keyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarkerValue)
    def maxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeysValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def versionIdMarker: ZIO[Any, AwsError, VersionIdMarker] =
      AwsError.unwrapOptionField("versionIdMarker", versionIdMarkerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ) extends io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
    override def keyMarkerValue: Option[KeyMarker] =
      scala.Option(impl.keyMarker()).map(value => value: KeyMarker)
    override def maxKeysValue: Option[MaxKeys] =
      scala.Option(impl.maxKeys()).map(value => value: MaxKeys)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def versionIdMarkerValue: Option[VersionIdMarker] =
      scala.Option(impl.versionIdMarker()).map(value => value: VersionIdMarker)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest
  ): io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
