package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  MaxKeys,
  NextVersionIdMarker,
  Prefix,
  VersionIdMarker,
  Delimiter,
  BucketName,
  KeyMarker,
  IsTruncated,
  NextKeyMarker
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListObjectVersionsResponse(
    isTruncated: Option[IsTruncated] = None,
    keyMarker: Option[KeyMarker] = None,
    versionIdMarker: Option[VersionIdMarker] = None,
    nextKeyMarker: Option[NextKeyMarker] = None,
    nextVersionIdMarker: Option[NextVersionIdMarker] = None,
    versions: Option[Iterable[io.github.vigoo.zioaws.s3.model.ObjectVersion]] =
      None,
    deleteMarkers: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry]
    ] = None,
    name: Option[BucketName] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    maxKeys: Option[MaxKeys] = None,
    commonPrefixes: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.CommonPrefix]
    ] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse = {
    import ListObjectVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
      .builder()
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(keyMarker.map(value => value: java.lang.String))(
        _.keyMarker
      )
      .optionallyWith(versionIdMarker.map(value => value: java.lang.String))(
        _.versionIdMarker
      )
      .optionallyWith(nextKeyMarker.map(value => value: java.lang.String))(
        _.nextKeyMarker
      )
      .optionallyWith(
        nextVersionIdMarker.map(value => value: java.lang.String)
      )(_.nextVersionIdMarker)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        deleteMarkers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleteMarkers)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(maxKeys.map(value => value: Integer))(_.maxKeys)
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListObjectVersionsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListObjectVersionsResponse
      .wrap(buildAwsValue())
}
object ListObjectVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListObjectVersionsResponse =
      io.github.vigoo.zioaws.s3.model.ListObjectVersionsResponse(
        isTruncatedValue.map(value => value),
        keyMarkerValue.map(value => value),
        versionIdMarkerValue.map(value => value),
        nextKeyMarkerValue.map(value => value),
        nextVersionIdMarkerValue.map(value => value),
        versionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        deleteMarkersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nameValue.map(value => value),
        prefixValue.map(value => value),
        delimiterValue.map(value => value),
        maxKeysValue.map(value => value),
        commonPrefixesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        encodingTypeValue.map(value => value)
      )
    def isTruncatedValue: Option[IsTruncated]
    def keyMarkerValue: Option[KeyMarker]
    def versionIdMarkerValue: Option[VersionIdMarker]
    def nextKeyMarkerValue: Option[NextKeyMarker]
    def nextVersionIdMarkerValue: Option[NextVersionIdMarker]
    def versionsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly]]
    def deleteMarkersValue: Option[
      List[io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.ReadOnly]
    ]
    def nameValue: Option[BucketName]
    def prefixValue: Option[Prefix]
    def delimiterValue: Option[Delimiter]
    def maxKeysValue: Option[MaxKeys]
    def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def keyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarkerValue)
    def versionIdMarker: ZIO[Any, AwsError, VersionIdMarker] =
      AwsError.unwrapOptionField("versionIdMarker", versionIdMarkerValue)
    def nextKeyMarker: ZIO[Any, AwsError, NextKeyMarker] =
      AwsError.unwrapOptionField("nextKeyMarker", nextKeyMarkerValue)
    def nextVersionIdMarker: ZIO[Any, AwsError, NextVersionIdMarker] = AwsError
      .unwrapOptionField("nextVersionIdMarker", nextVersionIdMarkerValue)
    def versions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versionsValue)
    def deleteMarkers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("deleteMarkers", deleteMarkersValue)
    def name: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", nameValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def maxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeysValue)
    def commonPrefixes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField("commonPrefixes", commonPrefixesValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListObjectVersionsResponse.ReadOnly {
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def keyMarkerValue: Option[KeyMarker] =
      scala.Option(impl.keyMarker()).map(value => value: KeyMarker)
    override def versionIdMarkerValue: Option[VersionIdMarker] =
      scala.Option(impl.versionIdMarker()).map(value => value: VersionIdMarker)
    override def nextKeyMarkerValue: Option[NextKeyMarker] =
      scala.Option(impl.nextKeyMarker()).map(value => value: NextKeyMarker)
    override def nextVersionIdMarkerValue: Option[NextVersionIdMarker] = scala
      .Option(impl.nextVersionIdMarker())
      .map(value => value: NextVersionIdMarker)
    override def versionsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly]] =
      scala
        .Option(impl.versions())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.ObjectVersion.wrap(item)
          }.toList
        )
    override def deleteMarkersValue: Option[
      List[io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.ReadOnly]
    ] = scala
      .Option(impl.deleteMarkers())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.wrap(item)
        }.toList
      )
    override def nameValue: Option[BucketName] =
      scala.Option(impl.name()).map(value => value: BucketName)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def maxKeysValue: Option[MaxKeys] =
      scala.Option(impl.maxKeys()).map(value => value: MaxKeys)
    override def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]] =
      scala
        .Option(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse
  ): io.github.vigoo.zioaws.s3.model.ListObjectVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
