package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  Marker,
  MaxKeys,
  Prefix,
  AccountId,
  Delimiter,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListObjectsRequest(
    bucket: BucketName,
    delimiter: Option[Delimiter] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None,
    marker: Option[Marker] = None,
    maxKeys: Option[MaxKeys] = None,
    prefix: Option[Prefix] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsRequest = {
    import ListObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxKeys.map(value => value: Integer))(_.maxKeys)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ListObjectsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListObjectsRequest.wrap(buildAwsValue())
}
object ListObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListObjectsRequest =
      io.github.vigoo.zioaws.s3.model.ListObjectsRequest(
        bucketValue,
        delimiterValue.map(value => value),
        encodingTypeValue.map(value => value),
        markerValue.map(value => value),
        maxKeysValue.map(value => value),
        prefixValue.map(value => value),
        requestPayerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def delimiterValue: Option[Delimiter]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def markerValue: Option[Marker]
    def maxKeysValue: Option[MaxKeys]
    def prefixValue: Option[Prefix]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
    def marker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", markerValue)
    def maxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeysValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsRequest
  ) extends io.github.vigoo.zioaws.s3.model.ListObjectsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
    override def markerValue: Option[Marker] =
      scala.Option(impl.marker()).map(value => value: Marker)
    override def maxKeysValue: Option[MaxKeys] =
      scala.Option(impl.maxKeys()).map(value => value: MaxKeys)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsRequest
  ): io.github.vigoo.zioaws.s3.model.ListObjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
