package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  Marker,
  MaxKeys,
  Prefix,
  NextMarker,
  Delimiter,
  BucketName,
  IsTruncated
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListObjectsResponse(
    isTruncated: Option[IsTruncated] = None,
    marker: Option[Marker] = None,
    nextMarker: Option[NextMarker] = None,
    contents: Option[Iterable[io.github.vigoo.zioaws.s3.model.S3Object]] = None,
    name: Option[BucketName] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    maxKeys: Option[MaxKeys] = None,
    commonPrefixes: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.CommonPrefix]
    ] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsResponse = {
    import ListObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsResponse
      .builder()
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        contents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contents)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(maxKeys.map(value => value: Integer))(_.maxKeys)
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListObjectsResponse.wrap(buildAwsValue())
}
object ListObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListObjectsResponse =
      io.github.vigoo.zioaws.s3.model.ListObjectsResponse(
        isTruncatedValue.map(value => value),
        markerValue.map(value => value),
        nextMarkerValue.map(value => value),
        contentsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nameValue.map(value => value),
        prefixValue.map(value => value),
        delimiterValue.map(value => value),
        maxKeysValue.map(value => value),
        commonPrefixesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        encodingTypeValue.map(value => value)
      )
    def isTruncatedValue: Option[IsTruncated]
    def markerValue: Option[Marker]
    def nextMarkerValue: Option[NextMarker]
    def contentsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly]]
    def nameValue: Option[BucketName]
    def prefixValue: Option[Prefix]
    def delimiterValue: Option[Delimiter]
    def maxKeysValue: Option[MaxKeys]
    def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def marker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", markerValue)
    def nextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarkerValue)
    def contents: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly
    ]] = AwsError.unwrapOptionField("contents", contentsValue)
    def name: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", nameValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def maxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeysValue)
    def commonPrefixes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField("commonPrefixes", commonPrefixesValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly {
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def markerValue: Option[Marker] =
      scala.Option(impl.marker()).map(value => value: Marker)
    override def nextMarkerValue: Option[NextMarker] =
      scala.Option(impl.nextMarker()).map(value => value: NextMarker)
    override def contentsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly]] =
      scala
        .Option(impl.contents())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.S3Object.wrap(item)
          }.toList
        )
    override def nameValue: Option[BucketName] =
      scala.Option(impl.name()).map(value => value: BucketName)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def maxKeysValue: Option[MaxKeys] =
      scala.Option(impl.maxKeys()).map(value => value: MaxKeys)
    override def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]] =
      scala
        .Option(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ): io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
