package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  MaxKeys,
  Token,
  Prefix,
  AccountId,
  FetchOwner,
  StartAfter,
  Delimiter,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListObjectsV2Request(
    bucket: BucketName,
    delimiter: Option[Delimiter] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None,
    maxKeys: Option[MaxKeys] = None,
    prefix: Option[Prefix] = None,
    continuationToken: Option[Token] = None,
    fetchOwner: Option[FetchOwner] = None,
    startAfter: Option[StartAfter] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsV2Request = {
    import ListObjectsV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsV2Request
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(maxKeys.map(value => value: Integer))(_.maxKeys)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .optionallyWith(fetchOwner.map(value => value: java.lang.Boolean))(
        _.fetchOwner
      )
      .optionallyWith(startAfter.map(value => value: java.lang.String))(
        _.startAfter
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListObjectsV2Request.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListObjectsV2Request.wrap(buildAwsValue())
}
object ListObjectsV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListObjectsV2Request =
      io.github.vigoo.zioaws.s3.model.ListObjectsV2Request(
        bucketValue,
        delimiterValue.map(value => value),
        encodingTypeValue.map(value => value),
        maxKeysValue.map(value => value),
        prefixValue.map(value => value),
        continuationTokenValue.map(value => value),
        fetchOwnerValue.map(value => value),
        startAfterValue.map(value => value),
        requestPayerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def delimiterValue: Option[Delimiter]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def maxKeysValue: Option[MaxKeys]
    def prefixValue: Option[Prefix]
    def continuationTokenValue: Option[Token]
    def fetchOwnerValue: Option[FetchOwner]
    def startAfterValue: Option[StartAfter]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
    def maxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeysValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
    def fetchOwner: ZIO[Any, AwsError, FetchOwner] =
      AwsError.unwrapOptionField("fetchOwner", fetchOwnerValue)
    def startAfter: ZIO[Any, AwsError, StartAfter] =
      AwsError.unwrapOptionField("startAfter", startAfterValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ) extends io.github.vigoo.zioaws.s3.model.ListObjectsV2Request.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
    override def maxKeysValue: Option[MaxKeys] =
      scala.Option(impl.maxKeys()).map(value => value: MaxKeys)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
    override def fetchOwnerValue: Option[FetchOwner] =
      scala.Option(impl.fetchOwner()).map(value => value: FetchOwner)
    override def startAfterValue: Option[StartAfter] =
      scala.Option(impl.startAfter()).map(value => value: StartAfter)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Request
  ): io.github.vigoo.zioaws.s3.model.ListObjectsV2Request.ReadOnly =
    new Wrapper(impl)
}
