package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  MaxKeys,
  NextToken,
  Token,
  Prefix,
  StartAfter,
  Delimiter,
  BucketName,
  IsTruncated,
  KeyCount
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListObjectsV2Response(
    isTruncated: Option[IsTruncated] = None,
    contents: Option[Iterable[io.github.vigoo.zioaws.s3.model.S3Object]] = None,
    name: Option[BucketName] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    maxKeys: Option[MaxKeys] = None,
    commonPrefixes: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.CommonPrefix]
    ] = None,
    encodingType: Option[io.github.vigoo.zioaws.s3.model.EncodingType] = None,
    keyCount: Option[KeyCount] = None,
    continuationToken: Option[Token] = None,
    nextContinuationToken: Option[NextToken] = None,
    startAfter: Option[StartAfter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsV2Response = {
    import ListObjectsV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsV2Response
      .builder()
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(
        contents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contents)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(delimiter.map(value => value: java.lang.String))(
        _.delimiter
      )
      .optionallyWith(maxKeys.map(value => value: Integer))(_.maxKeys)
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(keyCount.map(value => value: Integer))(_.keyCount)
      .optionallyWith(continuationToken.map(value => value: java.lang.String))(
        _.continuationToken
      )
      .optionallyWith(
        nextContinuationToken.map(value => value: java.lang.String)
      )(_.nextContinuationToken)
      .optionallyWith(startAfter.map(value => value: java.lang.String))(
        _.startAfter
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ListObjectsV2Response.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListObjectsV2Response.wrap(buildAwsValue())
}
object ListObjectsV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListObjectsV2Response =
      io.github.vigoo.zioaws.s3.model.ListObjectsV2Response(
        isTruncatedValue.map(value => value),
        contentsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nameValue.map(value => value),
        prefixValue.map(value => value),
        delimiterValue.map(value => value),
        maxKeysValue.map(value => value),
        commonPrefixesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        encodingTypeValue.map(value => value),
        keyCountValue.map(value => value),
        continuationTokenValue.map(value => value),
        nextContinuationTokenValue.map(value => value),
        startAfterValue.map(value => value)
      )
    def isTruncatedValue: Option[IsTruncated]
    def contentsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly]]
    def nameValue: Option[BucketName]
    def prefixValue: Option[Prefix]
    def delimiterValue: Option[Delimiter]
    def maxKeysValue: Option[MaxKeys]
    def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]]
    def encodingTypeValue: Option[io.github.vigoo.zioaws.s3.model.EncodingType]
    def keyCountValue: Option[KeyCount]
    def continuationTokenValue: Option[Token]
    def nextContinuationTokenValue: Option[NextToken]
    def startAfterValue: Option[StartAfter]
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def contents: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly
    ]] = AwsError.unwrapOptionField("contents", contentsValue)
    def name: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", nameValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def delimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiterValue)
    def maxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeysValue)
    def commonPrefixes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly
    ]] = AwsError.unwrapOptionField("commonPrefixes", commonPrefixesValue)
    def encodingType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingTypeValue)
    def keyCount: ZIO[Any, AwsError, KeyCount] =
      AwsError.unwrapOptionField("keyCount", keyCountValue)
    def continuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationTokenValue)
    def nextContinuationToken: ZIO[Any, AwsError, NextToken] = AwsError
      .unwrapOptionField("nextContinuationToken", nextContinuationTokenValue)
    def startAfter: ZIO[Any, AwsError, StartAfter] =
      AwsError.unwrapOptionField("startAfter", startAfterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ) extends io.github.vigoo.zioaws.s3.model.ListObjectsV2Response.ReadOnly {
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def contentsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly]] =
      scala
        .Option(impl.contents())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.S3Object.wrap(item)
          }.toList
        )
    override def nameValue: Option[BucketName] =
      scala.Option(impl.name()).map(value => value: BucketName)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def delimiterValue: Option[Delimiter] =
      scala.Option(impl.delimiter()).map(value => value: Delimiter)
    override def maxKeysValue: Option[MaxKeys] =
      scala.Option(impl.maxKeys()).map(value => value: MaxKeys)
    override def commonPrefixesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly]] =
      scala
        .Option(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override def encodingTypeValue
        : Option[io.github.vigoo.zioaws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => io.github.vigoo.zioaws.s3.model.EncodingType.wrap(value))
    override def keyCountValue: Option[KeyCount] =
      scala.Option(impl.keyCount()).map(value => value: KeyCount)
    override def continuationTokenValue: Option[Token] =
      scala.Option(impl.continuationToken()).map(value => value: Token)
    override def nextContinuationTokenValue: Option[NextToken] =
      scala.Option(impl.nextContinuationToken()).map(value => value: NextToken)
    override def startAfterValue: Option[StartAfter] =
      scala.Option(impl.startAfter()).map(value => value: StartAfter)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ): io.github.vigoo.zioaws.s3.model.ListObjectsV2Response.ReadOnly =
    new Wrapper(impl)
}
