package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  MaxParts,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  ObjectKey,
  BucketName,
  MultipartUploadId,
  PartNumberMarker
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPartsRequest(
    bucket: BucketName,
    key: ObjectKey,
    maxParts: Option[MaxParts] = None,
    partNumberMarker: Option[PartNumberMarker] = None,
    uploadId: MultipartUploadId,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListPartsRequest = {
    import ListPartsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListPartsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(maxParts.map(value => value: Integer))(_.maxParts)
      .optionallyWith(partNumberMarker.map(value => value: Integer))(
        _.partNumberMarker
      )
      .uploadId(uploadId: java.lang.String)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ListPartsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListPartsRequest.wrap(buildAwsValue())
}
object ListPartsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListPartsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListPartsRequest =
      io.github.vigoo.zioaws.s3.model.ListPartsRequest(
        bucketValue,
        keyValue,
        maxPartsValue.map(value => value),
        partNumberMarkerValue.map(value => value),
        uploadIdValue,
        requestPayerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def maxPartsValue: Option[MaxParts]
    def partNumberMarkerValue: Option[PartNumberMarker]
    def uploadIdValue: MultipartUploadId
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def expectedBucketOwnerValue: Option[AccountId]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def maxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxPartsValue)
    def partNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarkerValue)
    def uploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadIdValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListPartsRequest
  ) extends io.github.vigoo.zioaws.s3.model.ListPartsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def maxPartsValue: Option[MaxParts] =
      scala.Option(impl.maxParts()).map(value => value: MaxParts)
    override def partNumberMarkerValue: Option[PartNumberMarker] = scala
      .Option(impl.partNumberMarker())
      .map(value => value: PartNumberMarker)
    override def uploadIdValue: MultipartUploadId =
      impl.uploadId(): MultipartUploadId
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListPartsRequest
  ): io.github.vigoo.zioaws.s3.model.ListPartsRequest.ReadOnly = new Wrapper(
    impl
  )
}
