package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{
  MaxParts,
  AbortRuleId,
  NextPartNumberMarker,
  ObjectKey,
  BucketName,
  AbortDate,
  MultipartUploadId,
  PartNumberMarker,
  IsTruncated
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPartsResponse(
    abortDate: Option[AbortDate] = None,
    abortRuleId: Option[AbortRuleId] = None,
    bucket: Option[BucketName] = None,
    key: Option[ObjectKey] = None,
    uploadId: Option[MultipartUploadId] = None,
    partNumberMarker: Option[PartNumberMarker] = None,
    nextPartNumberMarker: Option[NextPartNumberMarker] = None,
    maxParts: Option[MaxParts] = None,
    isTruncated: Option[IsTruncated] = None,
    parts: Option[Iterable[io.github.vigoo.zioaws.s3.model.Part]] = None,
    initiator: Option[io.github.vigoo.zioaws.s3.model.Initiator] = None,
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListPartsResponse = {
    import ListPartsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListPartsResponse
      .builder()
      .optionallyWith(abortDate.map(value => value: Instant))(_.abortDate)
      .optionallyWith(abortRuleId.map(value => value: java.lang.String))(
        _.abortRuleId
      )
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(uploadId.map(value => value: java.lang.String))(
        _.uploadId
      )
      .optionallyWith(partNumberMarker.map(value => value: Integer))(
        _.partNumberMarker
      )
      .optionallyWith(nextPartNumberMarker.map(value => value: Integer))(
        _.nextPartNumberMarker
      )
      .optionallyWith(maxParts.map(value => value: Integer))(_.maxParts)
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ListPartsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ListPartsResponse.wrap(buildAwsValue())
}
object ListPartsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListPartsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ListPartsResponse =
      io.github.vigoo.zioaws.s3.model.ListPartsResponse(
        abortDateValue.map(value => value),
        abortRuleIdValue.map(value => value),
        bucketValue.map(value => value),
        keyValue.map(value => value),
        uploadIdValue.map(value => value),
        partNumberMarkerValue.map(value => value),
        nextPartNumberMarkerValue.map(value => value),
        maxPartsValue.map(value => value),
        isTruncatedValue.map(value => value),
        partsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        initiatorValue.map(value => value.editable),
        ownerValue.map(value => value.editable),
        storageClassValue.map(value => value),
        requestChargedValue.map(value => value),
        checksumAlgorithmValue.map(value => value)
      )
    def abortDateValue: Option[AbortDate]
    def abortRuleIdValue: Option[AbortRuleId]
    def bucketValue: Option[BucketName]
    def keyValue: Option[ObjectKey]
    def uploadIdValue: Option[MultipartUploadId]
    def partNumberMarkerValue: Option[PartNumberMarker]
    def nextPartNumberMarkerValue: Option[NextPartNumberMarker]
    def maxPartsValue: Option[MaxParts]
    def isTruncatedValue: Option[IsTruncated]
    def partsValue: Option[List[io.github.vigoo.zioaws.s3.model.Part.ReadOnly]]
    def initiatorValue
        : Option[io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly]
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def abortDate: ZIO[Any, AwsError, AbortDate] =
      AwsError.unwrapOptionField("abortDate", abortDateValue)
    def abortRuleId: ZIO[Any, AwsError, AbortRuleId] =
      AwsError.unwrapOptionField("abortRuleId", abortRuleIdValue)
    def bucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucketValue)
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def uploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadIdValue)
    def partNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarkerValue)
    def nextPartNumberMarker: ZIO[Any, AwsError, NextPartNumberMarker] =
      AwsError.unwrapOptionField(
        "nextPartNumberMarker",
        nextPartNumberMarkerValue
      )
    def maxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxPartsValue)
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def parts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Part.ReadOnly
    ]] = AwsError.unwrapOptionField("parts", partsValue)
    def initiator: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly
    ] = AwsError.unwrapOptionField("initiator", initiatorValue)
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListPartsResponse
  ) extends io.github.vigoo.zioaws.s3.model.ListPartsResponse.ReadOnly {
    override def abortDateValue: Option[AbortDate] =
      scala.Option(impl.abortDate()).map(value => value: AbortDate)
    override def abortRuleIdValue: Option[AbortRuleId] =
      scala.Option(impl.abortRuleId()).map(value => value: AbortRuleId)
    override def bucketValue: Option[BucketName] =
      scala.Option(impl.bucket()).map(value => value: BucketName)
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def uploadIdValue: Option[MultipartUploadId] =
      scala.Option(impl.uploadId()).map(value => value: MultipartUploadId)
    override def partNumberMarkerValue: Option[PartNumberMarker] = scala
      .Option(impl.partNumberMarker())
      .map(value => value: PartNumberMarker)
    override def nextPartNumberMarkerValue: Option[NextPartNumberMarker] = scala
      .Option(impl.nextPartNumberMarker())
      .map(value => value: NextPartNumberMarker)
    override def maxPartsValue: Option[MaxParts] =
      scala.Option(impl.maxParts()).map(value => value: MaxParts)
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def partsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Part.ReadOnly]] = scala
      .Option(impl.parts())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Part.wrap(item)
        }.toList
      )
    override def initiatorValue
        : Option[io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly] = scala
      .Option(impl.initiator())
      .map(value => io.github.vigoo.zioaws.s3.model.Initiator.wrap(value))
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListPartsResponse
  ): io.github.vigoo.zioaws.s3.model.ListPartsResponse.ReadOnly = new Wrapper(
    impl
  )
}
