package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{TargetPrefix, TargetBucket}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoggingEnabled(
    targetBucket: TargetBucket,
    targetGrants: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.TargetGrant]
    ] = None,
    targetPrefix: TargetPrefix
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LoggingEnabled = {
    import LoggingEnabled.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LoggingEnabled
      .builder()
      .targetBucket(targetBucket: java.lang.String)
      .optionallyWith(
        targetGrants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGrants)
      .targetPrefix(targetPrefix: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly =
    io.github.vigoo.zioaws.s3.model.LoggingEnabled.wrap(buildAwsValue())
}
object LoggingEnabled {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.LoggingEnabled] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.LoggingEnabled =
      io.github.vigoo.zioaws.s3.model.LoggingEnabled(
        targetBucketValue,
        targetGrantsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        targetPrefixValue
      )
    def targetBucketValue: TargetBucket
    def targetGrantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.TargetGrant.ReadOnly]]
    def targetPrefixValue: TargetPrefix
    def targetBucket: ZIO[Any, Nothing, TargetBucket] =
      ZIO.succeed(targetBucketValue)
    def targetGrants: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.TargetGrant.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGrants", targetGrantsValue)
    def targetPrefix: ZIO[Any, Nothing, TargetPrefix] =
      ZIO.succeed(targetPrefixValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LoggingEnabled
  ) extends io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly {
    override def targetBucketValue: TargetBucket =
      impl.targetBucket(): TargetBucket
    override def targetGrantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.TargetGrant.ReadOnly]] =
      scala
        .Option(impl.targetGrants())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.TargetGrant.wrap(item)
          }.toList
        )
    override def targetPrefixValue: TargetPrefix =
      impl.targetPrefix(): TargetPrefix
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LoggingEnabled
  ): io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly = new Wrapper(impl)
}
