package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{MetadataValue, MetadataKey}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetadataEntry(
    name: Option[MetadataKey] = None,
    value: Option[MetadataValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetadataEntry = {
    import MetadataEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetadataEntry
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.MetadataEntry.ReadOnly =
    io.github.vigoo.zioaws.s3.model.MetadataEntry.wrap(buildAwsValue())
}
object MetadataEntry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.MetadataEntry] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.MetadataEntry =
      io.github.vigoo.zioaws.s3.model.MetadataEntry(
        nameValue.map(value => value),
        valueValue.map(value => value)
      )
    def nameValue: Option[MetadataKey]
    def valueValue: Option[MetadataValue]
    def name: ZIO[Any, AwsError, MetadataKey] =
      AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, AwsError, MetadataValue] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetadataEntry
  ) extends io.github.vigoo.zioaws.s3.model.MetadataEntry.ReadOnly {
    override def nameValue: Option[MetadataKey] =
      scala.Option(impl.name()).map(value => value: MetadataKey)
    override def valueValue: Option[MetadataValue] =
      scala.Option(impl.value()).map(value => value: MetadataValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetadataEntry
  ): io.github.vigoo.zioaws.s3.model.MetadataEntry.ReadOnly = new Wrapper(impl)
}
