package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Metrics(
    status: io.github.vigoo.zioaws.s3.model.MetricsStatus,
    eventThreshold: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationTimeValue
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Metrics = {
    import Metrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Metrics
      .builder()
      .status(status.unwrap)
      .optionallyWith(eventThreshold.map(value => value.buildAwsValue()))(
        _.eventThreshold
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Metrics.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Metrics.wrap(buildAwsValue())
}
object Metrics {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Metrics] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Metrics =
      io.github.vigoo.zioaws.s3.model
        .Metrics(statusValue, eventThresholdValue.map(value => value.editable))
    def statusValue: io.github.vigoo.zioaws.s3.model.MetricsStatus
    def eventThresholdValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly]
    def status
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.MetricsStatus] =
      ZIO.succeed(statusValue)
    def eventThreshold: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly
    ] = AwsError.unwrapOptionField("eventThreshold", eventThresholdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Metrics)
      extends io.github.vigoo.zioaws.s3.model.Metrics.ReadOnly {
    override def statusValue: io.github.vigoo.zioaws.s3.model.MetricsStatus =
      io.github.vigoo.zioaws.s3.model.MetricsStatus.wrap(impl.status())
    override def eventThresholdValue: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly
    ] = scala
      .Option(impl.eventThreshold())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Metrics
  ): io.github.vigoo.zioaws.s3.model.Metrics.ReadOnly = new Wrapper(impl)
}
