package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccessPointArn, Prefix}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricsAndOperator(
    prefix: Option[Prefix] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.s3.model.Tag]] = None,
    accessPointArn: Option[AccessPointArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetricsAndOperator = {
    import MetricsAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetricsAndOperator
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(accessPointArn.map(value => value: java.lang.String))(
        _.accessPointArn
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.MetricsAndOperator.ReadOnly =
    io.github.vigoo.zioaws.s3.model.MetricsAndOperator.wrap(buildAwsValue())
}
object MetricsAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.MetricsAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.MetricsAndOperator =
      io.github.vigoo.zioaws.s3.model.MetricsAndOperator(
        prefixValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        accessPointArnValue.map(value => value)
      )
    def prefixValue: Option[Prefix]
    def tagsValue: Option[List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]]
    def accessPointArnValue: Option[AccessPointArn]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def accessPointArn: ZIO[Any, AwsError, AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetricsAndOperator
  ) extends io.github.vigoo.zioaws.s3.model.MetricsAndOperator.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Tag.wrap(item)
        }.toList
      )
    override def accessPointArnValue: Option[AccessPointArn] =
      scala.Option(impl.accessPointArn()).map(value => value: AccessPointArn)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetricsAndOperator
  ): io.github.vigoo.zioaws.s3.model.MetricsAndOperator.ReadOnly = new Wrapper(
    impl
  )
}
